/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.damagesource.DamageSource;

public record CriterionConditionDamage(CriterionConditionValue.DoubleRange dealtDamage, CriterionConditionValue.DoubleRange takenDamage, Optional<CriterionConditionEntity> sourceEntity, Optional<Boolean> blocked, Optional<CriterionConditionDamageSource> type) {
    public boolean matches(EntityPlayer var0, DamageSource var1, float var2, float var3, boolean var4) {
        if (!this.dealtDamage.matches(var2)) {
            return false;
        }
        if (!this.takenDamage.matches(var3)) {
            return false;
        }
        if (this.sourceEntity.isPresent() && !this.sourceEntity.get().matches(var0, var1.getEntity())) {
            return false;
        }
        if (this.blocked.isPresent() && this.blocked.get() != var4) {
            return false;
        }
        return !this.type.isPresent() || this.type.get().matches(var0, var1);
    }

    public static Optional<CriterionConditionDamage> fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return Optional.empty();
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "damage");
        CriterionConditionValue.DoubleRange var2 = CriterionConditionValue.DoubleRange.fromJson(var1.get("dealt"));
        CriterionConditionValue.DoubleRange var3 = CriterionConditionValue.DoubleRange.fromJson(var1.get("taken"));
        Optional<Boolean> var4 = var1.has("blocked") ? Optional.of(ChatDeserializer.getAsBoolean(var1, "blocked")) : Optional.empty();
        Optional<CriterionConditionEntity> var5 = CriterionConditionEntity.fromJson(var1.get("source_entity"));
        Optional<CriterionConditionDamageSource> var6 = CriterionConditionDamageSource.fromJson(var1.get("type"));
        if (var2.isAny() && var3.isAny() && var5.isEmpty() && var4.isEmpty() && var6.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CriterionConditionDamage(var2, var3, var5, var4, var6));
    }

    public JsonElement serializeToJson() {
        JsonObject var0 = new JsonObject();
        var0.add("dealt", this.dealtDamage.serializeToJson());
        var0.add("taken", this.takenDamage.serializeToJson());
        this.sourceEntity.ifPresent(var1 -> var0.add("source_entity", var1.serializeToJson()));
        this.type.ifPresent(var1 -> var0.add("type", var1.serializeToJson()));
        this.blocked.ifPresent(var1 -> var0.addProperty("blocked", var1));
        return var0;
    }

    public static class a {
        private CriterionConditionValue.DoubleRange dealtDamage = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange takenDamage = CriterionConditionValue.DoubleRange.ANY;
        private Optional<CriterionConditionEntity> sourceEntity = Optional.empty();
        private Optional<Boolean> blocked = Optional.empty();
        private Optional<CriterionConditionDamageSource> type = Optional.empty();

        public static a damageInstance() {
            return new a();
        }

        public a dealtDamage(CriterionConditionValue.DoubleRange var0) {
            this.dealtDamage = var0;
            return this;
        }

        public a takenDamage(CriterionConditionValue.DoubleRange var0) {
            this.takenDamage = var0;
            return this;
        }

        public a sourceEntity(CriterionConditionEntity var0) {
            this.sourceEntity = Optional.of(var0);
            return this;
        }

        public a blocked(Boolean var0) {
            this.blocked = Optional.of(var0);
            return this;
        }

        public a type(CriterionConditionDamageSource var0) {
            this.type = Optional.of(var0);
            return this;
        }

        public a type(CriterionConditionDamageSource.a var0) {
            this.type = Optional.of(var0.build());
            return this;
        }

        public CriterionConditionDamage build() {
            return new CriterionConditionDamage(this.dealtDamage, this.takenDamage, this.sourceEntity, this.blocked, this.type);
        }
    }
}

