/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class ContextAwarePredicate {
    private final List<LootItemCondition> conditions;
    private final Predicate<LootTableInfo> compositePredicates;

    ContextAwarePredicate(List<LootItemCondition> var0) {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("ContextAwarePredicate must have at least one condition");
        }
        this.conditions = var0;
        this.compositePredicates = LootItemConditions.andConditions(var0);
    }

    public static ContextAwarePredicate create(LootItemCondition ... var0) {
        return new ContextAwarePredicate(List.of(var0));
    }

    public static Optional<Optional<ContextAwarePredicate>> fromElement(String var0, LootDeserializationContext var1, @Nullable JsonElement var2, LootContextParameterSet var3) {
        if (var2 != null && var2.isJsonArray()) {
            List<LootItemCondition> var4 = var1.deserializeConditions(var2.getAsJsonArray(), var1.getAdvancementId() + "/" + var0, var3);
            if (var4.isEmpty()) {
                return Optional.of(Optional.empty());
            }
            return Optional.of(Optional.of(new ContextAwarePredicate(var4)));
        }
        return Optional.empty();
    }

    public boolean matches(LootTableInfo var0) {
        return this.compositePredicates.test(var0);
    }

    public JsonElement toJson() {
        return (JsonElement)SystemUtils.getOrThrow(LootItemConditions.CODEC.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, this.conditions), IllegalStateException::new);
    }

    public static JsonElement toJson(List<ContextAwarePredicate> var0) {
        if (var0.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonArray var1 = new JsonArray();
        for (ContextAwarePredicate var3 : var0) {
            var1.add(var3.toJson());
        }
        return var1;
    }
}

