/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;

public record Criterion<T extends CriterionInstance>(CriterionTrigger<T> trigger, T triggerInstance) {
    public static Criterion<?> criterionFromJson(JsonObject var0, LootDeserializationContext var1) {
        MinecraftKey var2 = new MinecraftKey(ChatDeserializer.getAsString(var0, "trigger"));
        CriterionTrigger var3 = CriterionTriggers.getCriterion(var2);
        if (var3 == null) {
            throw new JsonSyntaxException("Invalid criterion trigger: " + var2);
        }
        return Criterion.criterionFromJson(var0, var1, var3);
    }

    private static <T extends CriterionInstance> Criterion<T> criterionFromJson(JsonObject var0, LootDeserializationContext var1, CriterionTrigger<T> var2) {
        T var3 = var2.createInstance(ChatDeserializer.getAsJsonObject(var0, "conditions", new JsonObject()), var1);
        return new Criterion<T>(var2, var3);
    }

    public static Map<String, Criterion<?>> criteriaFromJson(JsonObject var0, LootDeserializationContext var1) {
        HashMap var2 = Maps.newHashMap();
        for (Map.Entry var4 : var0.entrySet()) {
            var2.put((String)var4.getKey(), Criterion.criterionFromJson(ChatDeserializer.convertToJsonObject((JsonElement)var4.getValue(), "criterion"), var1));
        }
        return var2;
    }

    public JsonElement serializeToJson() {
        JsonObject var0 = new JsonObject();
        var0.addProperty("trigger", Objects.requireNonNull(CriterionTriggers.getId(this.trigger), "Unregistered trigger").toString());
        JsonObject var1 = this.triggerInstance.serializeToJson();
        if (var1.size() != 0) {
            var0.add("conditions", (JsonElement)var1);
        }
        return var0;
    }
}

