/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ChatDeserializer;

public record AdvancementRequirements(String[][] requirements) {
    public static final AdvancementRequirements EMPTY = new AdvancementRequirements(new String[0][]);

    public AdvancementRequirements(PacketDataSerializer var0) {
        this(AdvancementRequirements.read(var0));
    }

    private static String[][] read(PacketDataSerializer var0) {
        String[][] var1 = new String[var0.readVarInt()][];
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = new String[var0.readVarInt()];
            for (int var3 = 0; var3 < var1[var2].length; ++var3) {
                var1[var2][var3] = var0.readUtf();
            }
        }
        return var1;
    }

    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.requirements.length);
        for (String[] var4 : this.requirements) {
            var0.writeVarInt(var4.length);
            for (String var8 : var4) {
                var0.writeUtf(var8);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static AdvancementRequirements allOf(Collection<String> var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static AdvancementRequirements anyOf(Collection<String> var0) {
        return new AdvancementRequirements(new String[][]{(String[])var0.toArray(String[]::new)});
    }

    public int size() {
        return this.requirements.length;
    }

    public boolean test(Predicate<String> var0) {
        if (this.requirements.length == 0) {
            return false;
        }
        for (String[] var4 : this.requirements) {
            if (AdvancementRequirements.anyMatch(var4, var0)) continue;
            return false;
        }
        return true;
    }

    public int count(Predicate<String> var0) {
        int var1 = 0;
        for (String[] var5 : this.requirements) {
            if (!AdvancementRequirements.anyMatch(var5, var0)) continue;
            ++var1;
        }
        return var1;
    }

    private static boolean anyMatch(String[] var0, Predicate<String> var1) {
        for (String var5 : var0) {
            if (!var1.test(var5)) continue;
            return true;
        }
        return false;
    }

    public static AdvancementRequirements fromJson(JsonArray var0, Set<String> var1) {
        JsonArray var5;
        String[][] var2 = new String[var0.size()][];
        ObjectOpenHashSet var3 = new ObjectOpenHashSet();
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            var5 = ChatDeserializer.convertToJsonArray(var0.get(var4), "requirements[" + var4 + "]");
            if (var5.isEmpty() && var1.isEmpty()) {
                throw new JsonSyntaxException("Requirement entry cannot be empty");
            }
            var2[var4] = new String[var5.size()];
            for (int var6 = 0; var6 < var5.size(); ++var6) {
                String var7;
                var2[var4][var6] = var7 = ChatDeserializer.convertToString(var5.get(var6), "requirements[" + var4 + "][" + var6 + "]");
                var3.add(var7);
            }
        }
        if (!var1.equals(var3)) {
            Sets.SetView var4 = Sets.difference(var1, (Set)var3);
            var5 = Sets.difference((Set)var3, var1);
            throw new JsonSyntaxException("Advancement completion requirements did not exactly match specified criteria. Missing: " + (Set)var4 + ". Unknown: " + (Set)var5);
        }
        return new AdvancementRequirements(var2);
    }

    public JsonArray toJson() {
        JsonArray var0 = new JsonArray();
        for (String[] var4 : this.requirements) {
            JsonArray var5 = new JsonArray();
            Arrays.stream(var4).forEach(arg_0 -> ((JsonArray)var5).add(arg_0));
            var0.add((JsonElement)var5);
        }
        return var0;
    }

    public boolean isEmpty() {
        return this.requirements.length == 0;
    }

    @Override
    public String toString() {
        return Arrays.deepToString((Object[])this.requirements);
    }

    public Set<String> names() {
        ObjectOpenHashSet var0 = new ObjectOpenHashSet();
        for (String[] var4 : this.requirements) {
            Collections.addAll(var0, var4);
        }
        return var0;
    }

    private static /* synthetic */ String[][] b(int var0) {
        return new String[var0][];
    }

    public static interface a {
        public static final a AND = AdvancementRequirements::allOf;
        public static final a OR = AdvancementRequirements::anyOf;

        public AdvancementRequirements create(Collection<String> var1);
    }
}

