/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public record Advancement(Optional<MinecraftKey> parent, Optional<AdvancementDisplay> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent, Optional<IChatBaseComponent> name) {
    public Advancement(Optional<MinecraftKey> var0, Optional<AdvancementDisplay> var1, AdvancementRewards var2, Map<String, Criterion<?>> var3, AdvancementRequirements var4, boolean var5) {
        this(var0, var1, var2, Map.copyOf(var3), var4, var5, var1.map(Advancement::decorateName));
    }

    private static IChatBaseComponent decorateName(AdvancementDisplay var0) {
        IChatBaseComponent var12 = var0.getTitle();
        EnumChatFormat var2 = var0.getFrame().getChatColor();
        IChatMutableComponent var3 = ChatComponentUtils.mergeStyles(var12.copy(), ChatModifier.EMPTY.withColor(var2)).append("\n").append(var0.getDescription());
        IChatMutableComponent var4 = var12.copy().withStyle(var1 -> var1.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, var3)));
        return ChatComponentUtils.wrapInSquareBrackets(var4).withStyle(var2);
    }

    public static IChatBaseComponent name(AdvancementHolder var0) {
        return var0.value().name().orElseGet(() -> IChatBaseComponent.literal(var0.id().toString()));
    }

    public JsonObject serializeToJson() {
        JsonObject var0 = new JsonObject();
        this.parent.ifPresent(var1 -> var0.addProperty("parent", var1.toString()));
        this.display.ifPresent(var1 -> var0.add("display", var1.serializeToJson()));
        var0.add("rewards", this.rewards.serializeToJson());
        JsonObject var12 = new JsonObject();
        for (Map.Entry<String, Criterion<?>> var3 : this.criteria.entrySet()) {
            var12.add(var3.getKey(), var3.getValue().serializeToJson());
        }
        var0.add("criteria", (JsonElement)var12);
        var0.add("requirements", (JsonElement)this.requirements.toJson());
        var0.addProperty("sends_telemetry_event", Boolean.valueOf(this.sendsTelemetryEvent));
        return var0;
    }

    public static Advancement fromJson(JsonObject var0, LootDeserializationContext var1) {
        Optional<MinecraftKey> var2 = var0.has("parent") ? Optional.of(new MinecraftKey(ChatDeserializer.getAsString(var0, "parent"))) : Optional.empty();
        Optional<AdvancementDisplay> var3 = var0.has("display") ? Optional.of(AdvancementDisplay.fromJson(ChatDeserializer.getAsJsonObject(var0, "display"))) : Optional.empty();
        AdvancementRewards var4 = var0.has("rewards") ? AdvancementRewards.deserialize(ChatDeserializer.getAsJsonObject(var0, "rewards")) : AdvancementRewards.EMPTY;
        Map<String, Criterion<?>> var5 = Criterion.criteriaFromJson(ChatDeserializer.getAsJsonObject(var0, "criteria"), var1);
        if (var5.isEmpty()) {
            throw new JsonSyntaxException("Advancement criteria cannot be empty");
        }
        JsonArray var6 = ChatDeserializer.getAsJsonArray(var0, "requirements", new JsonArray());
        AdvancementRequirements var7 = var6.isEmpty() ? AdvancementRequirements.allOf(var5.keySet()) : AdvancementRequirements.fromJson(var6, var5.keySet());
        boolean var8 = ChatDeserializer.getAsBoolean(var0, "sends_telemetry_event", false);
        return new Advancement(var2, var3, var4, var5, var7, var8);
    }

    public void write(PacketDataSerializer var02) {
        var02.writeOptional(this.parent, PacketDataSerializer::writeResourceLocation);
        var02.writeOptional(this.display, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
        this.requirements.write(var02);
        var02.writeBoolean(this.sendsTelemetryEvent);
    }

    public static Advancement read(PacketDataSerializer var0) {
        return new Advancement(var0.readOptional(PacketDataSerializer::readResourceLocation), var0.readOptional(AdvancementDisplay::fromNetwork), AdvancementRewards.EMPTY, Map.of(), new AdvancementRequirements(var0), var0.readBoolean());
    }

    public boolean isRoot() {
        return this.parent.isEmpty();
    }

    public static class SerializedAdvancement {
        private Optional<MinecraftKey> parent = Optional.empty();
        private Optional<AdvancementDisplay> display = Optional.empty();
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private final ImmutableMap.Builder<String, Criterion<?>> criteria = ImmutableMap.builder();
        private Optional<AdvancementRequirements> requirements = Optional.empty();
        private AdvancementRequirements.a requirementsStrategy = AdvancementRequirements.a.AND;
        private boolean sendsTelemetryEvent;

        public static SerializedAdvancement advancement() {
            return new SerializedAdvancement().sendsTelemetryEvent();
        }

        public static SerializedAdvancement recipeAdvancement() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement parent(AdvancementHolder var0) {
            this.parent = Optional.of(var0.id());
            return this;
        }

        @Deprecated(forRemoval=true)
        public SerializedAdvancement parent(MinecraftKey var0) {
            this.parent = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement display(ItemStack var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(var0, var1, var2, var3, var4, var5, var6, var7));
        }

        public SerializedAdvancement display(IMaterial var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(new ItemStack(var0.asItem()), var1, var2, var3, var4, var5, var6, var7));
        }

        public SerializedAdvancement display(AdvancementDisplay var0) {
            this.display = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement rewards(AdvancementRewards.a var0) {
            return this.rewards(var0.build());
        }

        public SerializedAdvancement rewards(AdvancementRewards var0) {
            this.rewards = var0;
            return this;
        }

        public SerializedAdvancement addCriterion(String var0, Criterion<?> var1) {
            this.criteria.put((Object)var0, var1);
            return this;
        }

        public SerializedAdvancement requirements(AdvancementRequirements.a var0) {
            this.requirementsStrategy = var0;
            return this;
        }

        public SerializedAdvancement requirements(AdvancementRequirements var0) {
            this.requirements = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement sendsTelemetryEvent() {
            this.sendsTelemetryEvent = true;
            return this;
        }

        public AdvancementHolder build(MinecraftKey var0) {
            ImmutableMap var1 = this.criteria.buildOrThrow();
            AdvancementRequirements var2 = this.requirements.orElseGet(() -> this.a((Map)var1));
            return new AdvancementHolder(var0, new Advancement(this.parent, this.display, this.rewards, (Map<String, Criterion<?>>)var1, var2, this.sendsTelemetryEvent));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> var0, String var1) {
            AdvancementHolder var2 = this.build(new MinecraftKey(var1));
            var0.accept(var2);
            return var2;
        }

        private /* synthetic */ AdvancementRequirements a(Map var0) {
            return this.requirementsStrategy.create(var0.keySet());
        }
    }
}

