/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final String BLOCK_ENTITY_ID = "block_entity";
    private static final a BLOCK_ENTITY_PROVIDER = new a(){

        @Override
        public NBTBase get(LootTableInfo var0) {
            TileEntity var1 = var0.getParamOrNull(LootContextParameters.BLOCK_ENTITY);
            return var1 != null ? var1.saveWithFullMetadata() : null;
        }

        @Override
        public String getId() {
            return ContextNbtProvider.BLOCK_ENTITY_ID;
        }

        @Override
        public Set<LootContextParameter<?>> getReferencedContextParams() {
            return ImmutableSet.of(LootContextParameters.BLOCK_ENTITY);
        }
    };
    public static final ContextNbtProvider BLOCK_ENTITY = new ContextNbtProvider(BLOCK_ENTITY_PROVIDER);
    final a getter;

    private static a forEntity(final LootTableInfo.EntityTarget var0) {
        return new a(){

            @Override
            @Nullable
            public NBTBase get(LootTableInfo var02) {
                Entity var1 = var02.getParamOrNull(var0.getParam());
                return var1 != null ? CriterionConditionNBT.getEntityTagToCompare(var1) : null;
            }

            @Override
            public String getId() {
                return var0.name();
            }

            @Override
            public Set<LootContextParameter<?>> getReferencedContextParams() {
                return ImmutableSet.of(var0.getParam());
            }
        };
    }

    private ContextNbtProvider(a var0) {
        this.getter = var0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public NBTBase get(LootTableInfo var0) {
        return this.getter.get(var0);
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.getter.getReferencedContextParams();
    }

    public static NbtProvider forContextEntity(LootTableInfo.EntityTarget var0) {
        return new ContextNbtProvider(ContextNbtProvider.forEntity(var0));
    }

    static ContextNbtProvider createFromContext(String var0) {
        if (var0.equals(BLOCK_ENTITY_ID)) {
            return new ContextNbtProvider(BLOCK_ENTITY_PROVIDER);
        }
        LootTableInfo.EntityTarget var1 = LootTableInfo.EntityTarget.getByName(var0);
        return new ContextNbtProvider(ContextNbtProvider.forEntity(var1));
    }

    static interface a {
        @Nullable
        public NBTBase get(LootTableInfo var1);

        public String getId();

        public Set<LootContextParameter<?>> getReferencedContextParams();
    }

    public static class b
    implements JsonRegistry.b<ContextNbtProvider> {
        @Override
        public JsonElement serialize(ContextNbtProvider var0, JsonSerializationContext var1) {
            return new JsonPrimitive(var0.getter.getId());
        }

        @Override
        public ContextNbtProvider deserialize(JsonElement var0, JsonDeserializationContext var1) {
            String var2 = var0.getAsString();
            return ContextNbtProvider.createFromContext(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonElement jsonElement, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonElement, jsonDeserializationContext);
        }
    }

    public static class c
    implements LootSerializer<ContextNbtProvider> {
        @Override
        public void serialize(JsonObject var0, ContextNbtProvider var1, JsonSerializationContext var2) {
            var0.addProperty("target", var1.getter.getId());
        }

        @Override
        public ContextNbtProvider deserialize(JsonObject var0, JsonDeserializationContext var1) {
            String var2 = ChatDeserializer.getAsString(var0, "target");
            return ContextNbtProvider.createFromContext(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

