/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyState
extends LootItemFunctionConditional {
    final Block block;
    final Set<IBlockState<?>> properties;

    LootItemFunctionCopyState(LootItemCondition[] var0, Block var1, Set<IBlockState<?>> var2) {
        super(var0);
        this.block = var1;
        this.properties = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_STATE;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.BLOCK_STATE);
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        IBlockData var22 = var1.getParamOrNull(LootContextParameters.BLOCK_STATE);
        if (var22 != null) {
            NBTTagCompound var4;
            NBTTagCompound var3 = var0.getOrCreateTag();
            if (var3.contains("BlockStateTag", 10)) {
                var4 = var3.getCompound("BlockStateTag");
            } else {
                var4 = new NBTTagCompound();
                var3.put("BlockStateTag", var4);
            }
            this.properties.stream().filter(var22::hasProperty).forEach(var2 -> var4.putString(var2.getName(), LootItemFunctionCopyState.serialize(var22, var2)));
        }
        return var0;
    }

    public static a copyState(Block var0) {
        return new a(var0);
    }

    private static <T extends Comparable<T>> String serialize(IBlockData var0, IBlockState<T> var1) {
        T var2 = var0.getValue(var1);
        return var1.getName(var2);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Block block;
        private final Set<IBlockState<?>> properties = Sets.newHashSet();

        a(Block var0) {
            this.block = var0;
        }

        public a copy(IBlockState<?> var0) {
            if (!this.block.getStateDefinition().getProperties().contains(var0)) {
                throw new IllegalStateException("Property " + var0 + " is not present on block " + this.block);
            }
            this.properties.add(var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionCopyState(this.getConditions(), this.block, this.properties);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionCopyState> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionCopyState var12, JsonSerializationContext var2) {
            super.serialize(var0, var12, var2);
            var0.addProperty("block", BuiltInRegistries.BLOCK.getKey(var12.block).toString());
            JsonArray var3 = new JsonArray();
            var12.properties.forEach(var1 -> var3.add(var1.getName()));
            var0.add("properties", (JsonElement)var3);
        }

        @Override
        public LootItemFunctionCopyState deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var22) {
            MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            Block var4 = (Block)BuiltInRegistries.BLOCK.getOptional(var3).orElseThrow(() -> new IllegalArgumentException("Can't find block " + var3));
            BlockStateList<Block, IBlockData> var5 = var4.getStateDefinition();
            HashSet var6 = Sets.newHashSet();
            JsonArray var7 = ChatDeserializer.getAsJsonArray(var0, "properties", null);
            if (var7 != null) {
                var7.forEach(var2 -> var6.add(var5.getProperty(ChatDeserializer.convertToString(var2, "property"))));
            }
            return new LootItemFunctionCopyState(var22, var4, var6);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

