/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyName
extends LootItemFunctionConditional {
    final Source source;

    LootItemFunctionCopyName(LootItemCondition[] var0, Source var1) {
        super(var0);
        this.source = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        INamableTileEntity var3;
        Object var2 = var1.getParamOrNull(this.source.param);
        if (var2 instanceof INamableTileEntity && (var3 = (INamableTileEntity)var2).hasCustomName()) {
            var0.setHoverName(var3.getDisplayName());
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> copyName(Source var0) {
        return LootItemFunctionCopyName.simpleBuilder(var1 -> new LootItemFunctionCopyName((LootItemCondition[])var1, var0));
    }

    public static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source THIS = new Source("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ Source KILLER = new Source("killer", LootContextParameters.KILLER_ENTITY);
        public static final /* enum */ Source KILLER_PLAYER = new Source("killer_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        public static final /* enum */ Source BLOCK_ENTITY = new Source("block_entity", LootContextParameters.BLOCK_ENTITY);
        public final String name;
        public final LootContextParameter<?> param;
        private static final /* synthetic */ Source[] g;

        public static Source[] values() {
            return (Source[])g.clone();
        }

        public static Source valueOf(String var0) {
            return Enum.valueOf(Source.class, var0);
        }

        private Source(String var2, LootContextParameter var3) {
            this.name = var2;
            this.param = var3;
        }

        public static Source getByName(String var0) {
            for (Source var4 : Source.values()) {
                if (!var4.name.equals(var0)) continue;
                return var4;
            }
            throw new IllegalArgumentException("Invalid name source " + var0);
        }

        private static /* synthetic */ Source[] a() {
            return new Source[]{THIS, KILLER, KILLER_PLAYER, BLOCK_ENTITY};
        }

        static {
            g = Source.a();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionCopyName> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionCopyName var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("source", var1.source.name);
        }

        @Override
        public LootItemFunctionCopyName deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            Source var3 = Source.getByName(ChatDeserializer.getAsString(var0, "source"));
            return new LootItemFunctionCopyName(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

