/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    final MinecraftKey name;

    FunctionReference(LootItemCondition[] var0, MinecraftKey var1) {
        super(var0);
        this.name = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        LootDataId<LootItemFunction> var1 = new LootDataId<LootItemFunction>(LootDataType.MODIFIER, this.name);
        if (var0.hasVisitedElement(var1)) {
            var0.reportProblem("Function " + this.name + " is recursively called");
            return;
        }
        super.validate(var0);
        var0.resolver().getElementOptional(var1).ifPresentOrElse(var2 -> var2.validate(var0.enterElement(".{" + this.name + "}", var1)), () -> var0.reportProblem("Unknown function table called " + this.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        LootItemFunction var2 = var1.getResolver().getElement(LootDataType.MODIFIER, this.name);
        if (var2 == null) {
            LOGGER.warn("Unknown function: {}", (Object)this.name);
            return var0;
        }
        LootTableInfo.c<LootItemFunction> var3 = LootTableInfo.createVisitedEntry(var2);
        if (var1.pushVisitedElement(var3)) {
            try {
                ItemStack itemStack = (ItemStack)var2.apply(var0, var1);
                return itemStack;
            }
            finally {
                var1.popVisitedElement(var3);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return var0;
    }

    public static LootItemFunctionConditional.a<?> functionReference(MinecraftKey var0) {
        return FunctionReference.simpleBuilder(var1 -> new FunctionReference((LootItemCondition[])var1, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<FunctionReference> {
        @Override
        public void serialize(JsonObject var0, FunctionReference var1, JsonSerializationContext var2) {
            var0.addProperty("name", var1.name.toString());
        }

        @Override
        public FunctionReference deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "name"));
            return new FunctionReference(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

