/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final LootParams params;
    private final RandomSource random;
    private final LootDataResolver lootDataResolver;
    private final Set<c<?>> visitedElements = Sets.newLinkedHashSet();

    LootTableInfo(LootParams var0, RandomSource var1, LootDataResolver var2) {
        this.params = var0;
        this.random = var1;
        this.lootDataResolver = var2;
    }

    public boolean hasParam(LootContextParameter<?> var0) {
        return this.params.hasParam(var0);
    }

    public <T> T getParam(LootContextParameter<T> var0) {
        return this.params.getParameter(var0);
    }

    public void addDynamicDrops(MinecraftKey var0, Consumer<ItemStack> var1) {
        this.params.addDynamicDrops(var0, var1);
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParameter<T> var0) {
        return this.params.getParamOrNull(var0);
    }

    public boolean hasVisitedElement(c<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public boolean pushVisitedElement(c<?> var0) {
        return this.visitedElements.add(var0);
    }

    public void popVisitedElement(c<?> var0) {
        this.visitedElements.remove(var0);
    }

    public LootDataResolver getResolver() {
        return this.lootDataResolver;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.params.getLuck();
    }

    public WorldServer getLevel() {
        return this.params.getLevel();
    }

    public static c<LootTable> createVisitedEntry(LootTable var0) {
        return new c<LootTable>(LootDataType.TABLE, var0);
    }

    public static c<LootItemCondition> createVisitedEntry(LootItemCondition var0) {
        return new c<LootItemCondition>(LootDataType.PREDICATE, var0);
    }

    public static c<LootItemFunction> createVisitedEntry(LootItemFunction var0) {
        return new c<LootItemFunction>(LootDataType.MODIFIER, var0);
    }

    public record c<T>(LootDataType<T> type, T value) {
    }

    public static final class EntityTarget
    extends Enum<EntityTarget> {
        public static final /* enum */ EntityTarget THIS = new EntityTarget("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ EntityTarget KILLER = new EntityTarget("killer", LootContextParameters.KILLER_ENTITY);
        public static final /* enum */ EntityTarget DIRECT_KILLER = new EntityTarget("direct_killer", LootContextParameters.DIRECT_KILLER_ENTITY);
        public static final /* enum */ EntityTarget KILLER_PLAYER = new EntityTarget("killer_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        final String name;
        private final LootContextParameter<? extends Entity> param;
        private static final /* synthetic */ EntityTarget[] g;

        public static EntityTarget[] values() {
            return (EntityTarget[])g.clone();
        }

        public static EntityTarget valueOf(String var0) {
            return Enum.valueOf(EntityTarget.class, var0);
        }

        private EntityTarget(String var2, LootContextParameter var3) {
            this.name = var2;
            this.param = var3;
        }

        public LootContextParameter<? extends Entity> getParam() {
            return this.param;
        }

        public static EntityTarget getByName(String var0) {
            for (EntityTarget var4 : EntityTarget.values()) {
                if (!var4.name.equals(var0)) continue;
                return var4;
            }
            throw new IllegalArgumentException("Invalid entity target " + var0);
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{THIS, KILLER, DIRECT_KILLER, KILLER_PLAYER};
        }

        static {
            g = EntityTarget.b();
        }

        public static class a
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter var0, EntityTarget var1) throws IOException {
                var0.value(var1.name);
            }

            public EntityTarget read(JsonReader var0) throws IOException {
                return EntityTarget.getByName(var0.nextString());
            }

            public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                return this.read(jsonReader);
            }

            public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                this.write(jsonWriter, (EntityTarget)((Object)object));
            }
        }
    }

    public static class Builder {
        private final LootParams params;
        @Nullable
        private RandomSource random;

        public Builder(LootParams var0) {
            this.params = var0;
        }

        public Builder withOptionalRandomSeed(long var0) {
            if (var0 != 0L) {
                this.random = RandomSource.create(var0);
            }
            return this;
        }

        public WorldServer getLevel() {
            return this.params.getLevel();
        }

        public LootTableInfo create(@Nullable MinecraftKey var0) {
            WorldServer var1 = this.getLevel();
            MinecraftServer var2 = var1.getServer();
            RandomSource var3 = this.random != null ? this.random : (var0 != null ? var1.getRandomSequence(var0) : var1.getRandom());
            return new LootTableInfo(this.params, var3, var2.getLootData());
        }
    }
}

