/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class LootTable {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final LootTable EMPTY = new LootTable(LootContextParameterSets.EMPTY, null, new LootSelector[0], new LootItemFunction[0]);
    public static final LootContextParameterSet DEFAULT_PARAM_SET = LootContextParameterSets.ALL_PARAMS;
    final LootContextParameterSet paramSet;
    @Nullable
    final MinecraftKey randomSequence;
    final LootSelector[] pools;
    final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

    LootTable(LootContextParameterSet var0, @Nullable MinecraftKey var1, LootSelector[] var2, LootItemFunction[] var3) {
        this.paramSet = var0;
        this.randomSequence = var1;
        this.pools = var2;
        this.functions = var3;
        this.compositeFunction = LootItemFunctions.compose(var3);
    }

    public static Consumer<ItemStack> createStackSplitter(WorldServer var0, Consumer<ItemStack> var1) {
        return var2 -> {
            if (!var2.isItemEnabled(var0.enabledFeatures())) {
                return;
            }
            if (var2.getCount() < var2.getMaxStackSize()) {
                var1.accept((ItemStack)var2);
            } else {
                ItemStack var4;
                for (int var3 = var2.getCount(); var3 > 0; var3 -= var4.getCount()) {
                    var4 = var2.copyWithCount(Math.min(var2.getMaxStackSize(), var3));
                    var1.accept(var4);
                }
            }
        };
    }

    public void getRandomItemsRaw(LootParams var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(var0).create(this.randomSequence), var1);
    }

    public void getRandomItemsRaw(LootTableInfo var0, Consumer<ItemStack> var1) {
        LootTableInfo.c<LootTable> var2 = LootTableInfo.createVisitedEntry(this);
        if (var0.pushVisitedElement(var2)) {
            Consumer<ItemStack> var3 = LootItemFunction.decorate(this.compositeFunction, var1, var0);
            for (LootSelector var7 : this.pools) {
                var7.addRandomItems(var3, var0);
            }
            var0.popVisitedElement(var2);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams var0, long var1, Consumer<ItemStack> var3) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(var0).withOptionalRandomSeed(var1).create(this.randomSequence), LootTable.createStackSplitter(var0.getLevel(), var3));
    }

    public void getRandomItems(LootParams var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(var0, LootTable.createStackSplitter(var0.getLevel(), var1));
    }

    public void getRandomItems(LootTableInfo var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(var0, LootTable.createStackSplitter(var0.getLevel(), var1));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams var0, long var1) {
        return this.getRandomItems(new LootTableInfo.Builder(var0).withOptionalRandomSeed(var1).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams var0) {
        return this.getRandomItems(new LootTableInfo.Builder(var0).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootTableInfo var0) {
        ObjectArrayList var1 = new ObjectArrayList();
        this.getRandomItems(var0, arg_0 -> ((ObjectArrayList)var1).add(arg_0));
        return var1;
    }

    public LootContextParameterSet getParamSet() {
        return this.paramSet;
    }

    public void validate(LootCollector var0) {
        int var1;
        for (var1 = 0; var1 < this.pools.length; ++var1) {
            this.pools[var1].validate(var0.forChild(".pools[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.functions.length; ++var1) {
            this.functions[var1].validate(var0.forChild(".functions[" + var1 + "]"));
        }
    }

    public void fill(IInventory var0, LootParams var1, long var2) {
        LootTableInfo var4 = new LootTableInfo.Builder(var1).withOptionalRandomSeed(var2).create(this.randomSequence);
        ObjectArrayList<ItemStack> var5 = this.getRandomItems(var4);
        RandomSource var6 = var4.getRandom();
        List<Integer> var7 = this.getAvailableSlots(var0, var6);
        this.shuffleAndSplitItems(var5, var7.size(), var6);
        for (ItemStack var9 : var5) {
            if (var7.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (var9.isEmpty()) {
                var0.setItem(var7.remove(var7.size() - 1), ItemStack.EMPTY);
                continue;
            }
            var0.setItem(var7.remove(var7.size() - 1), var9);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> var0, int var1, RandomSource var2) {
        ArrayList var3 = Lists.newArrayList();
        Object var4 = var0.iterator();
        while (var4.hasNext()) {
            ItemStack var5 = (ItemStack)var4.next();
            if (var5.isEmpty()) {
                var4.remove();
                continue;
            }
            if (var5.getCount() <= 1) continue;
            var3.add(var5);
            var4.remove();
        }
        while (var1 - var0.size() - var3.size() > 0 && !var3.isEmpty()) {
            var4 = (ItemStack)var3.remove(MathHelper.nextInt(var2, 0, var3.size() - 1));
            int var5 = MathHelper.nextInt(var2, 1, ((ItemStack)var4).getCount() / 2);
            ItemStack var6 = ((ItemStack)var4).split(var5);
            if (((ItemStack)var4).getCount() > 1 && var2.nextBoolean()) {
                var3.add(var4);
            } else {
                var0.add(var4);
            }
            if (var6.getCount() > 1 && var2.nextBoolean()) {
                var3.add(var6);
                continue;
            }
            var0.add((Object)var6);
        }
        var0.addAll((Collection)var3);
        SystemUtils.shuffle(var0, var2);
    }

    private List<Integer> getAvailableSlots(IInventory var0, RandomSource var1) {
        ObjectArrayList var2 = new ObjectArrayList();
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            if (!var0.getItem(var3).isEmpty()) continue;
            var2.add((Object)var3);
        }
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static a lootTable() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final List<LootSelector> pools = Lists.newArrayList();
        private final List<LootItemFunction> functions = Lists.newArrayList();
        private LootContextParameterSet paramSet = DEFAULT_PARAM_SET;
        @Nullable
        private MinecraftKey randomSequence = null;

        public a withPool(LootSelector.a var0) {
            this.pools.add(var0.build());
            return this;
        }

        public a setParamSet(LootContextParameterSet var0) {
            this.paramSet = var0;
            return this;
        }

        public a setRandomSequence(MinecraftKey var0) {
            this.randomSequence = var0;
            return this;
        }

        @Override
        public a apply(LootItemFunction.a var0) {
            this.functions.add(var0.build());
            return this;
        }

        @Override
        public a unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, this.pools.toArray(new LootSelector[0]), this.functions.toArray(new LootItemFunction[0]));
        }

        @Override
        public /* synthetic */ LootItemFunctionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }
    }

    public static class b
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            LootItemFunction[] var7;
            Object var6;
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "loot table");
            LootSelector[] var4 = ChatDeserializer.getAsObject(var3, "pools", new LootSelector[0], var2, LootSelector[].class);
            LootContextParameterSet var5 = null;
            if (var3.has("type")) {
                var6 = ChatDeserializer.getAsString(var3, "type");
                var5 = LootContextParameterSets.get(new MinecraftKey((String)var6));
            }
            if (var3.has("random_sequence")) {
                var7 = ChatDeserializer.getAsString(var3, "random_sequence");
                var6 = new MinecraftKey((String)var7);
            } else {
                var6 = null;
            }
            var7 = ChatDeserializer.getAsObject(var3, "functions", new LootItemFunction[0], var2, LootItemFunction[].class);
            return new LootTable(var5 != null ? var5 : LootContextParameterSets.ALL_PARAMS, (MinecraftKey)var6, var4, var7);
        }

        public JsonElement serialize(LootTable var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            if (var0.paramSet != DEFAULT_PARAM_SET) {
                MinecraftKey var4 = LootContextParameterSets.getKey(var0.paramSet);
                if (var4 != null) {
                    var3.addProperty("type", var4.toString());
                } else {
                    LOGGER.warn("Failed to find id for param set {}", (Object)var0.paramSet);
                }
            }
            if (var0.randomSequence != null) {
                var3.addProperty("random_sequence", var0.randomSequence.toString());
            }
            if (var0.pools.length > 0) {
                var3.add("pools", var2.serialize((Object)var0.pools));
            }
            if (!ArrayUtils.isEmpty((Object[])var0.functions)) {
                var3.add("functions", var2.serialize((Object)var0.functions));
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootTable)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

