/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.lang.invoke.TypeDescriptor;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootDataType<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType(LootSerialization.createConditionSerializer().create(), LootDataType.createSingleOrMultipleDeserialiser(LootItemCondition.class, LootDataManager::createComposite), "predicates", LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType(LootSerialization.createFunctionSerializer().create(), LootDataType.createSingleOrMultipleDeserialiser(LootItemFunction.class, LootDataManager::createComposite), "item_modifiers", LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(LootSerialization.createLootTableSerializer().create(), LootDataType.createSingleDeserialiser(LootTable.class), "loot_tables", LootDataType.createLootTableValidator());
    private final Gson parser;
    private final BiFunction<MinecraftKey, JsonElement, Optional<T>> topDeserializer;
    private final String directory;
    private final a<T> validator;

    private LootDataType(Gson var0, BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> var1, String var2, a<T> var3) {
        this.parser = var0;
        this.directory = var2;
        this.validator = var3;
        this.topDeserializer = var1.apply(var0, var2);
    }

    public Gson parser() {
        return this.parser;
    }

    public String directory() {
        return this.directory;
    }

    public void runValidation(LootCollector var0, LootDataId<T> var1, T var2) {
        this.validator.run(var0, var1, var2);
    }

    public Optional<T> deserialize(MinecraftKey var0, JsonElement var1) {
        return this.topDeserializer.apply(var0, var1);
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T> BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> createSingleDeserialiser(Class<T> var0) {
        return (var1, var2) -> (var3, var4) -> {
            try {
                return Optional.of(var1.fromJson(var4, var0));
            }
            catch (Exception var5) {
                LOGGER.error("Couldn't parse element {}:{}", new Object[]{var2, var3, var5});
                return Optional.empty();
            }
        };
    }

    private static <T> BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> createSingleOrMultipleDeserialiser(Class<T> var0, Function<T[], T> var1) {
        TypeDescriptor.OfField var2 = var0.arrayType();
        return (arg_0, arg_1) -> LootDataType.a((Class)var2, var1, var0, arg_0, arg_1);
    }

    private static <T extends LootItemUser> a<T> createSimpleValidator() {
        return (var0, var1, var2) -> var2.validate(var0.enterElement("{" + var1.type().directory + ":" + var1.location() + "}", var1));
    }

    private static a<LootTable> createLootTableValidator() {
        return (var0, var1, var2) -> var2.validate(var0.setParams(var2.getParamSet()).enterElement("{" + var1.type().directory + ":" + var1.location() + "}", var1));
    }

    private static /* synthetic */ BiFunction a(Class var0, Function var1, Class var2, Gson var3, String var4) {
        return (var5, var6) -> {
            try {
                if (var6.isJsonArray()) {
                    Object[] var7 = (Object[])var3.fromJson(var6, var0);
                    return Optional.of(var1.apply(var7));
                }
                return Optional.of(var3.fromJson(var6, var2));
            }
            catch (Exception var7) {
                LOGGER.error("Couldn't parse element {}:{}", new Object[]{var4, var5, var7});
                return Optional.empty();
            }
        };
    }

    @FunctionalInterface
    public static interface a<T> {
        public void run(LootCollector var1, LootDataId<T> var2, T var3);
    }
}

