/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializerType;

public class JsonRegistry {
    public static <E, T extends LootSerializerType<E>> a<E, T> builder(IRegistry<T> var0, String var1, String var2, Function<E, T> var3) {
        return new a<E, T>(var0, var1, var2, var3);
    }

    public static class a<E, T extends LootSerializerType<E>> {
        private final IRegistry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private Pair<T, b<? extends E>> inlineType;
        @Nullable
        private T defaultType;

        a(IRegistry<T> var0, String var1, String var2, Function<E, T> var3) {
            this.registry = var0;
            this.elementName = var1;
            this.typeKey = var2;
            this.typeGetter = var3;
        }

        public a<E, T> withInlineSerializer(T var0, b<? extends E> var1) {
            this.inlineType = Pair.of(var0, var1);
            return this;
        }

        public a<E, T> withDefaultType(T var0) {
            this.defaultType = var0;
            return this;
        }

        public Object build() {
            return new c<E, T>(this.registry, this.elementName, this.typeKey, this.typeGetter, this.defaultType, this.inlineType);
        }
    }

    public static interface b<T> {
        public JsonElement serialize(T var1, JsonSerializationContext var2);

        public T deserialize(JsonElement var1, JsonDeserializationContext var2);
    }

    static class c<E, T extends LootSerializerType<E>>
    implements JsonDeserializer<E>,
    JsonSerializer<E> {
        private final IRegistry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private final T defaultType;
        @Nullable
        private final Pair<T, b<? extends E>> inlineType;

        c(IRegistry<T> var0, String var1, String var2, Function<E, T> var3, @Nullable T var4, @Nullable Pair<T, b<? extends E>> var5) {
            this.registry = var0;
            this.elementName = var1;
            this.typeKey = var2;
            this.typeGetter = var3;
            this.defaultType = var4;
            this.inlineType = var5;
        }

        public E deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            if (var0.isJsonObject()) {
                Object var4;
                JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, this.elementName);
                String var5 = ChatDeserializer.getAsString(var3, this.typeKey, "");
                if (var5.isEmpty()) {
                    var4 = this.defaultType;
                } else {
                    MinecraftKey var6 = new MinecraftKey(var5);
                    var4 = (LootSerializerType)this.registry.get(var6);
                }
                if (var4 == null) {
                    throw new JsonSyntaxException("Unknown type '" + var5 + "'");
                }
                return (E)((LootSerializerType)var4).getSerializer().deserialize(var3, var2);
            }
            if (this.inlineType == null) {
                throw new UnsupportedOperationException("Object " + var0 + " can't be deserialized");
            }
            return (E)((b)this.inlineType.getSecond()).deserialize(var0, var2);
        }

        public JsonElement serialize(E var0, Type var1, JsonSerializationContext var2) {
            LootSerializerType var3 = (LootSerializerType)this.typeGetter.apply(var0);
            if (this.inlineType != null && this.inlineType.getFirst() == var3) {
                return ((b)this.inlineType.getSecond()).serialize(var0, var2);
            }
            if (var3 == null) {
                throw new JsonSyntaxException("Unknown type: " + var0);
            }
            JsonObject var4 = new JsonObject();
            var4.addProperty(this.typeKey, this.registry.getKey(var3).toString());
            var3.getSerializer().serialize(var4, var0, var2);
            return var4;
        }
    }
}

