/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathEntity {
    private final List<PathPoint> nodes;
    private PathPoint[] openSet = new PathPoint[0];
    private PathPoint[] closedSet = new PathPoint[0];
    @Nullable
    private Set<PathDestination> targetNodes;
    private int nextNodeIndex;
    private final BlockPosition target;
    private final float distToTarget;
    private final boolean reached;

    public PathEntity(List<PathPoint> var0, BlockPosition var1, boolean var2) {
        this.nodes = var0;
        this.target = var1;
        this.distToTarget = var0.isEmpty() ? Float.MAX_VALUE : this.nodes.get(this.nodes.size() - 1).distanceManhattan(this.target);
        this.reached = var2;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public PathPoint getEndNode() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public PathPoint getNode(int var0) {
        return this.nodes.get(var0);
    }

    public void truncateNodes(int var0) {
        if (this.nodes.size() > var0) {
            this.nodes.subList(var0, this.nodes.size()).clear();
        }
    }

    public void replaceNode(int var0, PathPoint var1) {
        this.nodes.set(var0, var1);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setNextNodeIndex(int var0) {
        this.nextNodeIndex = var0;
    }

    public Vec3D getEntityPosAtNode(Entity var0, int var1) {
        PathPoint var2 = this.nodes.get(var1);
        double var3 = (double)var2.x + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        double var5 = var2.y;
        double var7 = (double)var2.z + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        return new Vec3D(var3, var5, var7);
    }

    public BlockPosition getNodePos(int var0) {
        return this.nodes.get(var0).asBlockPos();
    }

    public Vec3D getNextEntityPos(Entity var0) {
        return this.getEntityPosAtNode(var0, this.nextNodeIndex);
    }

    public BlockPosition getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public PathPoint getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public PathPoint getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable PathEntity var0) {
        if (var0 == null) {
            return false;
        }
        if (var0.nodes.size() != this.nodes.size()) {
            return false;
        }
        for (int var1 = 0; var1 < this.nodes.size(); ++var1) {
            PathPoint var2 = this.nodes.get(var1);
            PathPoint var3 = var0.nodes.get(var1);
            if (var2.x == var3.x && var2.y == var3.y && var2.z == var3.z) continue;
            return false;
        }
        return true;
    }

    public boolean canReach() {
        return this.reached;
    }

    @VisibleForDebug
    void setDebug(PathPoint[] var0, PathPoint[] var1, Set<PathDestination> var2) {
        this.openSet = var0;
        this.closedSet = var1;
        this.targetNodes = var2;
    }

    @VisibleForDebug
    public PathPoint[] getOpenSet() {
        return this.openSet;
    }

    @VisibleForDebug
    public PathPoint[] getClosedSet() {
        return this.closedSet;
    }

    public void writeToStream(PacketDataSerializer var0) {
        if (this.targetNodes == null || this.targetNodes.isEmpty()) {
            return;
        }
        var0.writeBoolean(this.reached);
        var0.writeInt(this.nextNodeIndex);
        var0.writeInt(this.targetNodes.size());
        this.targetNodes.forEach(var1 -> var1.writeToStream(var0));
        var0.writeInt(this.target.getX());
        var0.writeInt(this.target.getY());
        var0.writeInt(this.target.getZ());
        var0.writeInt(this.nodes.size());
        for (PathPoint var2 : this.nodes) {
            var2.writeToStream(var0);
        }
        var0.writeInt(this.openSet.length);
        for (PathPoint var4 : this.openSet) {
            var4.writeToStream(var0);
        }
        var0.writeInt(this.closedSet.length);
        for (PathPoint var4 : this.closedSet) {
            var4.writeToStream(var0);
        }
    }

    public static PathEntity createFromStream(PacketDataSerializer var0) {
        boolean var1 = var0.readBoolean();
        int var2 = var0.readInt();
        int var3 = var0.readInt();
        HashSet var4 = Sets.newHashSet();
        for (int var5 = 0; var5 < var3; ++var5) {
            var4.add(PathDestination.createFromStream(var0));
        }
        BlockPosition var5 = new BlockPosition(var0.readInt(), var0.readInt(), var0.readInt());
        ArrayList var6 = Lists.newArrayList();
        int var7 = var0.readInt();
        for (int var8 = 0; var8 < var7; ++var8) {
            var6.add(PathPoint.createFromStream(var0));
        }
        PathPoint[] var8 = new PathPoint[var0.readInt()];
        for (int var9 = 0; var9 < var8.length; ++var9) {
            var8[var9] = PathPoint.createFromStream(var0);
        }
        PathPoint[] var9 = new PathPoint[var0.readInt()];
        for (int var10 = 0; var10 < var9.length; ++var10) {
            var9[var10] = PathPoint.createFromStream(var0);
        }
        PathEntity var10 = new PathEntity(var6, var5, var1);
        var10.openSet = var8;
        var10.closedSet = var9;
        var10.targetNodes = var4;
        var10.nextNodeIndex = var2;
        return var10;
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public BlockPosition getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }
}

