/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;

public class DefinedStructureInfo {
    private EnumBlockMirror mirror = EnumBlockMirror.NONE;
    private EnumBlockRotation rotation = EnumBlockRotation.NONE;
    private BlockPosition rotationPivot = BlockPosition.ZERO;
    private boolean ignoreEntities;
    @Nullable
    private StructureBoundingBox boundingBox;
    private boolean keepLiquids = true;
    @Nullable
    private RandomSource random;
    private int palette;
    private final List<DefinedStructureProcessor> processors = Lists.newArrayList();
    private boolean knownShape;
    private boolean finalizeEntities;

    public DefinedStructureInfo copy() {
        DefinedStructureInfo var0 = new DefinedStructureInfo();
        var0.mirror = this.mirror;
        var0.rotation = this.rotation;
        var0.rotationPivot = this.rotationPivot;
        var0.ignoreEntities = this.ignoreEntities;
        var0.boundingBox = this.boundingBox;
        var0.keepLiquids = this.keepLiquids;
        var0.random = this.random;
        var0.palette = this.palette;
        var0.processors.addAll(this.processors);
        var0.knownShape = this.knownShape;
        var0.finalizeEntities = this.finalizeEntities;
        return var0;
    }

    public DefinedStructureInfo setMirror(EnumBlockMirror var0) {
        this.mirror = var0;
        return this;
    }

    public DefinedStructureInfo setRotation(EnumBlockRotation var0) {
        this.rotation = var0;
        return this;
    }

    public DefinedStructureInfo setRotationPivot(BlockPosition var0) {
        this.rotationPivot = var0;
        return this;
    }

    public DefinedStructureInfo setIgnoreEntities(boolean var0) {
        this.ignoreEntities = var0;
        return this;
    }

    public DefinedStructureInfo setBoundingBox(StructureBoundingBox var0) {
        this.boundingBox = var0;
        return this;
    }

    public DefinedStructureInfo setRandom(@Nullable RandomSource var0) {
        this.random = var0;
        return this;
    }

    public DefinedStructureInfo setKeepLiquids(boolean var0) {
        this.keepLiquids = var0;
        return this;
    }

    public DefinedStructureInfo setKnownShape(boolean var0) {
        this.knownShape = var0;
        return this;
    }

    public DefinedStructureInfo clearProcessors() {
        this.processors.clear();
        return this;
    }

    public DefinedStructureInfo addProcessor(DefinedStructureProcessor var0) {
        this.processors.add(var0);
        return this;
    }

    public DefinedStructureInfo popProcessor(DefinedStructureProcessor var0) {
        this.processors.remove(var0);
        return this;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public BlockPosition getRotationPivot() {
        return this.rotationPivot;
    }

    public RandomSource getRandom(@Nullable BlockPosition var0) {
        if (this.random != null) {
            return this.random;
        }
        if (var0 == null) {
            return RandomSource.create(SystemUtils.getMillis());
        }
        return RandomSource.create(MathHelper.getSeed(var0));
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    @Nullable
    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean getKnownShape() {
        return this.knownShape;
    }

    public List<DefinedStructureProcessor> getProcessors() {
        return this.processors;
    }

    public boolean shouldKeepLiquids() {
        return this.keepLiquids;
    }

    public DefinedStructure.a getRandomPalette(List<DefinedStructure.a> var0, @Nullable BlockPosition var1) {
        int var2 = var0.size();
        if (var2 == 0) {
            throw new IllegalStateException("No palettes");
        }
        return var0.get(this.getRandom(var1).nextInt(var2));
    }

    public DefinedStructureInfo setFinalizeEntities(boolean var0) {
        this.finalizeEntities = var0;
        return this;
    }

    public boolean shouldFinalizeEntities() {
        return this.finalizeEntities;
    }
}

