/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTables;

public class IglooPieces {
    public static final int GENERATION_HEIGHT = 90;
    static final MinecraftKey STRUCTURE_LOCATION_IGLOO = new MinecraftKey("igloo/top");
    private static final MinecraftKey STRUCTURE_LOCATION_LADDER = new MinecraftKey("igloo/middle");
    private static final MinecraftKey STRUCTURE_LOCATION_LABORATORY = new MinecraftKey("igloo/bottom");
    static final Map<MinecraftKey, BlockPosition> PIVOTS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)new BlockPosition(3, 5, 5), (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPosition(1, 3, 1), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPosition(3, 6, 7));
    static final Map<MinecraftKey, BlockPosition> OFFSETS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)BlockPosition.ZERO, (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPosition(2, -3, 4), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPosition(0, -3, -2));

    public static void addPieces(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, StructurePieceAccessor var3, RandomSource var4) {
        if (var4.nextDouble() < 0.5) {
            int var5 = var4.nextInt(8) + 4;
            var3.addPiece(new a(var0, STRUCTURE_LOCATION_LABORATORY, var1, var2, var5 * 3));
            for (int var6 = 0; var6 < var5 - 1; ++var6) {
                var3.addPiece(new a(var0, STRUCTURE_LOCATION_LADDER, var1, var2, var6 * 3));
            }
        }
        var3.addPiece(new a(var0, STRUCTURE_LOCATION_IGLOO, var1, var2, 0));
    }

    public static class a
    extends DefinedStructurePiece {
        public a(StructureTemplateManager var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, int var4) {
            super(WorldGenFeatureStructurePieceType.IGLOO, 0, var0, var1, var1.toString(), a.makeSettings(var3, var1), a.makePosition(var1, var2, var4));
        }

        public a(StructureTemplateManager var0, NBTTagCompound var12) {
            super(WorldGenFeatureStructurePieceType.IGLOO, var12, var0, var1 -> a.makeSettings(EnumBlockRotation.valueOf(var12.getString("Rot")), var1));
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation var0, MinecraftKey var1) {
            return new DefinedStructureInfo().setRotation(var0).setMirror(EnumBlockMirror.NONE).setRotationPivot(PIVOTS.get(var1)).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        }

        private static BlockPosition makePosition(MinecraftKey var0, BlockPosition var1, int var2) {
            return var1.offset(OFFSETS.get(var0)).below(var2);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putString("Rot", this.placeSettings.getRotation().name());
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
            if (!"chest".equals(var0)) {
                return;
            }
            var2.setBlock(var1, Blocks.AIR.defaultBlockState(), 3);
            TileEntity var5 = var2.getBlockEntity(var1.below());
            if (var5 instanceof TileEntityChest) {
                ((TileEntityChest)var5).setLootTable(LootTables.IGLOO_CHEST, var3.nextLong());
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            BlockPosition var13;
            IBlockData var14;
            MinecraftKey var7 = new MinecraftKey(this.templateName);
            DefinedStructureInfo var8 = a.makeSettings(this.placeSettings.getRotation(), var7);
            BlockPosition var9 = OFFSETS.get(var7);
            BlockPosition var10 = this.templatePosition.offset(DefinedStructure.calculateRelativePosition(var8, new BlockPosition(3 - var9.getX(), 0, -var9.getZ())));
            int var11 = var0.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var10.getX(), var10.getZ());
            BlockPosition var12 = this.templatePosition;
            this.templatePosition = this.templatePosition.offset(0, var11 - 90 - 1, 0);
            super.postProcess(var0, var1, var2, var3, var4, var5, var6);
            if (var7.equals(STRUCTURE_LOCATION_IGLOO) && !(var14 = var0.getBlockState((var13 = this.templatePosition.offset(DefinedStructure.calculateRelativePosition(var8, new BlockPosition(3, 0, 5)))).below())).isAir() && !var14.is(Blocks.LADDER)) {
                var0.setBlock(var13, Blocks.SNOW_BLOCK.defaultBlockState(), 3);
            }
            this.templatePosition = var12;
        }
    }
}

