/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> CURRENT_TO_LEGACY_MAP = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put("Village", "Village");
        var0.put("Mineshaft", "Mineshaft");
        var0.put("Mansion", "Mansion");
        var0.put("Igloo", "Temple");
        var0.put("Desert_Pyramid", "Temple");
        var0.put("Jungle_Pyramid", "Temple");
        var0.put("Swamp_Hut", "Temple");
        var0.put("Stronghold", "Stronghold");
        var0.put("Monument", "Monument");
        var0.put("Fortress", "Fortress");
        var0.put("EndCity", "EndCity");
    });
    private static final Map<String, String> LEGACY_TO_CURRENT_MAP = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put("Iglu", "Igloo");
        var0.put("TeDP", "Desert_Pyramid");
        var0.put("TeJP", "Jungle_Pyramid");
        var0.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> OLD_STRUCTURE_REGISTRY_KEYS = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean hasLegacyData;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> dataMap = Maps.newHashMap();
    private final Map<String, PersistentIndexed> indexMap = Maps.newHashMap();
    private final List<String> legacyKeys;
    private final List<String> currentKeys;

    public PersistentStructureLegacy(@Nullable WorldPersistentData var0, List<String> var1, List<String> var2) {
        this.legacyKeys = var1;
        this.currentKeys = var2;
        this.populateCaches(var0);
        boolean var3 = false;
        for (String var5 : this.currentKeys) {
            var3 |= this.dataMap.get(var5) != null;
        }
        this.hasLegacyData = var3;
    }

    public void removeIndex(long var0) {
        for (String var3 : this.legacyKeys) {
            PersistentIndexed var4 = this.indexMap.get(var3);
            if (var4 == null || !var4.hasUnhandledIndex(var0)) continue;
            var4.removeIndex(var0);
            var4.setDirty();
        }
    }

    public NBTTagCompound updateFromLegacy(NBTTagCompound var0) {
        NBTTagCompound var1 = var0.getCompound("Level");
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1.getInt("xPos"), var1.getInt("zPos"));
        if (this.isUnhandledStructureStart(var2.x, var2.z)) {
            var0 = this.updateStructureStart(var0, var2);
        }
        NBTTagCompound var3 = var1.getCompound("Structures");
        NBTTagCompound var4 = var3.getCompound("References");
        for (String var6 : this.currentKeys) {
            boolean var7 = OLD_STRUCTURE_REGISTRY_KEYS.contains(var6.toLowerCase(Locale.ROOT));
            if (var4.contains(var6, 12) || !var7) continue;
            int var8 = 8;
            LongArrayList var9 = new LongArrayList();
            for (int var10 = var2.x - 8; var10 <= var2.x + 8; ++var10) {
                for (int var11 = var2.z - 8; var11 <= var2.z + 8; ++var11) {
                    if (!this.hasLegacyStart(var10, var11, var6)) continue;
                    var9.add(ChunkCoordIntPair.asLong(var10, var11));
                }
            }
            var4.putLongArray(var6, (List<Long>)var9);
        }
        var3.put("References", var4);
        var1.put("Structures", var3);
        var0.put("Level", var1);
        return var0;
    }

    private boolean hasLegacyStart(int var0, int var1, String var2) {
        if (!this.hasLegacyData) {
            return false;
        }
        return this.dataMap.get(var2) != null && this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var2)).hasStartIndex(ChunkCoordIntPair.asLong(var0, var1));
    }

    private boolean isUnhandledStructureStart(int var0, int var1) {
        if (!this.hasLegacyData) {
            return false;
        }
        for (String var3 : this.currentKeys) {
            if (this.dataMap.get(var3) == null || !this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var3)).hasUnhandledIndex(ChunkCoordIntPair.asLong(var0, var1))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound updateStructureStart(NBTTagCompound var0, ChunkCoordIntPair var1) {
        NBTTagCompound var2 = var0.getCompound("Level");
        NBTTagCompound var3 = var2.getCompound("Structures");
        NBTTagCompound var4 = var3.getCompound("Starts");
        for (String var6 : this.currentKeys) {
            NBTTagCompound var10;
            Long2ObjectMap<NBTTagCompound> var7 = this.dataMap.get(var6);
            if (var7 == null) continue;
            long var8 = var1.toLong();
            if (!this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var6)).hasUnhandledIndex(var8) || (var10 = (NBTTagCompound)var7.get(var8)) == null) continue;
            var4.put(var6, var10);
        }
        var3.put("Starts", var4);
        var2.put("Structures", var3);
        var0.put("Level", var2);
        return var0;
    }

    private void populateCaches(@Nullable WorldPersistentData var02) {
        if (var02 == null) {
            return;
        }
        for (String var2 : this.legacyKeys) {
            NBTBase var9;
            Object var6;
            NBTTagCompound var3 = new NBTTagCompound();
            try {
                var3 = var02.readTagFromDisk(var2, 1493).getCompound("data").getCompound("Features");
                if (var3.isEmpty()) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String string : var3.getAllKeys()) {
                String var10;
                String var11;
                var6 = var3.getCompound(string);
                long var7 = ChunkCoordIntPair.asLong(((NBTTagCompound)var6).getInt("ChunkX"), ((NBTTagCompound)var6).getInt("ChunkZ"));
                var9 = ((NBTTagCompound)var6).getList("Children", 10);
                if (!((NBTTagList)var9).isEmpty() && (var11 = LEGACY_TO_CURRENT_MAP.get(var10 = ((NBTTagList)var9).getCompound(0).getString("id"))) != null) {
                    ((NBTTagCompound)var6).putString("id", var11);
                }
                var10 = ((NBTTagCompound)var6).getString("id");
                this.dataMap.computeIfAbsent(var10, var0 -> new Long2ObjectOpenHashMap()).put(var7, var6);
            }
            String var4 = var2 + "_index";
            PersistentIndexed persistentIndexed = var02.computeIfAbsent(PersistentIndexed::load, PersistentIndexed::new, var4);
            if (persistentIndexed.getAll().isEmpty()) {
                var6 = new PersistentIndexed();
                this.indexMap.put(var2, (PersistentIndexed)var6);
                for (String var8 : var3.getAllKeys()) {
                    var9 = var3.getCompound(var8);
                    ((PersistentIndexed)var6).addIndex(ChunkCoordIntPair.asLong(((NBTTagCompound)var9).getInt("ChunkX"), ((NBTTagCompound)var9).getInt("ChunkZ")));
                }
                ((PersistentBase)var6).setDirty();
                continue;
            }
            this.indexMap.put(var2, persistentIndexed);
        }
    }

    public static PersistentStructureLegacy getLegacyStructureHandler(ResourceKey<World> var0, @Nullable WorldPersistentData var1) {
        if (var0 == World.OVERWORLD) {
            return new PersistentStructureLegacy(var1, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (var0 == World.NETHER) {
            ImmutableList var2 = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(var1, (List<String>)var2, (List<String>)var2);
        }
        if (var0 == World.END) {
            ImmutableList var2 = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(var1, (List<String>)var2, (List<String>)var2);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", var0));
    }
}

