/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;

public class UnderwaterMagmaFeature
extends WorldGenerator<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<UnderwaterMagmaConfiguration> var0) {
        BaseBlockPosition var7;
        GeneratorAccessSeed var12 = var0.level();
        BlockPosition var22 = var0.origin();
        UnderwaterMagmaConfiguration var3 = var0.config();
        RandomSource var4 = var0.random();
        OptionalInt var5 = UnderwaterMagmaFeature.getFloorY(var12, var22, var3);
        if (!var5.isPresent()) {
            return false;
        }
        BlockPosition var6 = var22.atY(var5.getAsInt());
        AxisAlignedBB var8 = new AxisAlignedBB(var6.subtract(var7 = new BaseBlockPosition(var3.placementRadiusAroundFloor, var3.placementRadiusAroundFloor, var3.placementRadiusAroundFloor)), var6.offset(var7));
        return BlockPosition.betweenClosedStream(var8).filter(var2 -> var4.nextFloat() < var1.placementProbabilityPerValidPosition).filter(var1 -> this.isValidPlacement(var12, (BlockPosition)var1)).mapToInt(var1 -> {
            var12.setBlock((BlockPosition)var1, Blocks.MAGMA_BLOCK.defaultBlockState(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt getFloorY(GeneratorAccessSeed var02, BlockPosition var1, UnderwaterMagmaConfiguration var2) {
        Predicate<IBlockData> var3 = var0 -> var0.is(Blocks.WATER);
        Predicate<IBlockData> var4 = var0 -> !var0.is(Blocks.WATER);
        Optional<Column> var5 = Column.scan(var02, var1, var2.floorSearchRange, var3, var4);
        return var5.map(Column::getFloor).orElseGet(OptionalInt::empty);
    }

    private boolean isValidPlacement(GeneratorAccessSeed var0, BlockPosition var1) {
        if (this.isWaterOrAir(var0, var1) || this.isWaterOrAir(var0, var1.below())) {
            return false;
        }
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (!this.isWaterOrAir(var0, var1.relative(var3))) continue;
            return false;
        }
        return true;
    }

    private boolean isWaterOrAir(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.is(Blocks.WATER) || var2.isAir();
    }
}

