/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Codec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.Xoroshiro128PlusPlus;

public class XoroshiroRandomSource
implements RandomSource {
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    public static final Codec<XoroshiroRandomSource> CODEC = Xoroshiro128PlusPlus.CODEC.xmap(var0 -> new XoroshiroRandomSource((Xoroshiro128PlusPlus)var0), var0 -> var0.randomNumberGenerator);
    private Xoroshiro128PlusPlus randomNumberGenerator;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public XoroshiroRandomSource(long var0) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(RandomSupport.upgradeSeedTo128bit(var0));
    }

    public XoroshiroRandomSource(RandomSupport.a var0) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(var0);
    }

    public XoroshiroRandomSource(long var0, long var2) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(var0, var2);
    }

    private XoroshiroRandomSource(Xoroshiro128PlusPlus var0) {
        this.randomNumberGenerator = var0;
    }

    @Override
    public RandomSource fork() {
        return new XoroshiroRandomSource(this.randomNumberGenerator.nextLong(), this.randomNumberGenerator.nextLong());
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return new a(this.randomNumberGenerator.nextLong(), this.randomNumberGenerator.nextLong());
    }

    @Override
    public void setSeed(long var0) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(RandomSupport.upgradeSeedTo128bit(var0));
        this.gaussianSource.reset();
    }

    @Override
    public int nextInt() {
        return (int)this.randomNumberGenerator.nextLong();
    }

    @Override
    public int nextInt(int var0) {
        if (var0 <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long var1 = Integer.toUnsignedLong(this.nextInt());
        long var3 = var1 * (long)var0;
        long var5 = var3 & 0xFFFFFFFFL;
        if (var5 < (long)var0) {
            int var7 = Integer.remainderUnsigned(~var0 + 1, var0);
            while (var5 < (long)var7) {
                var1 = Integer.toUnsignedLong(this.nextInt());
                var3 = var1 * (long)var0;
                var5 = var3 & 0xFFFFFFFFL;
            }
        }
        long var7 = var3 >> 32;
        return (int)var7;
    }

    @Override
    public long nextLong() {
        return this.randomNumberGenerator.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return (this.randomNumberGenerator.nextLong() & 1L) != 0L;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextBits(24) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextBits(53) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    @Override
    public void consumeCount(int var0) {
        for (int var1 = 0; var1 < var0; ++var1) {
            this.randomNumberGenerator.nextLong();
        }
    }

    private long nextBits(int var0) {
        return this.randomNumberGenerator.nextLong() >>> 64 - var0;
    }

    public static class a
    implements PositionalRandomFactory {
        private final long seedLo;
        private final long seedHi;

        public a(long var0, long var2) {
            this.seedLo = var0;
            this.seedHi = var2;
        }

        @Override
        public RandomSource at(int var0, int var1, int var2) {
            long var3 = MathHelper.getSeed(var0, var1, var2);
            long var5 = var3 ^ this.seedLo;
            return new XoroshiroRandomSource(var5, this.seedHi);
        }

        @Override
        public RandomSource fromHashOf(String var0) {
            RandomSupport.a var1 = RandomSupport.seedFromHashOf(var0);
            return new XoroshiroRandomSource(var1.xor(this.seedLo, this.seedHi));
        }

        @Override
        @VisibleForTesting
        public void parityConfigString(StringBuilder var0) {
            var0.append("seedLo: ").append(this.seedLo).append(", seedHi: ").append(this.seedHi);
        }
    }
}

