/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ChunkStatus {
    public static final int MAX_STRUCTURE_DISTANCE = 8;
    private static final EnumSet<HeightMap.Type> PRE_FEATURES = EnumSet.of(HeightMap.Type.OCEAN_FLOOR_WG, HeightMap.Type.WORLD_SURFACE_WG);
    public static final EnumSet<HeightMap.Type> POST_FEATURES = EnumSet.of(HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE, HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES);
    private static final c PASSTHROUGH_LOAD_TASK = (var0, var1, var2, var3, var4, var5) -> CompletableFuture.completedFuture(Either.left((Object)var5));
    public static final ChunkStatus EMPTY = ChunkStatus.registerSimple("empty", null, -1, PRE_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {});
    public static final ChunkStatus STRUCTURE_STARTS = ChunkStatus.register("structure_starts", EMPTY, 0, false, PRE_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4, var5, var6, var7, var8) -> {
        if (var2.getServer().getWorldData().worldGenOptions().generateStructures()) {
            var3.createStructures(var2.registryAccess(), var2.getChunkSource().getGeneratorState(), var2.structureManager(), var8, var4);
        }
        var2.onStructureStartsAvailable(var8);
        return CompletableFuture.completedFuture(Either.left((Object)var8));
    }, (var0, var1, var2, var3, var4, var5) -> {
        var1.onStructureStartsAvailable(var5);
        return CompletableFuture.completedFuture(Either.left((Object)var5));
    });
    public static final ChunkStatus STRUCTURE_REFERENCES = ChunkStatus.registerSimple("structure_references", STRUCTURE_STARTS, 8, PRE_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var1, var3, var0, -1);
        var2.createReferences(var5, var1.structureManager().forWorldGenRegion(var5), var4);
    });
    public static final ChunkStatus BIOMES = ChunkStatus.register("biomes", STRUCTURE_REFERENCES, 8, PRE_FEATURES, Type.PROTOCHUNK, (var02, var1, var2, var3, var4, var5, var6, var7, var8) -> {
        RegionLimitedWorldAccess var9 = new RegionLimitedWorldAccess(var2, var7, var02, -1);
        return var3.createBiomes(var1, var2.getChunkSource().randomState(), Blender.of(var9), var2.structureManager().forWorldGenRegion(var9), var8).thenApply(var0 -> Either.left((Object)var0));
    });
    public static final ChunkStatus NOISE = ChunkStatus.register("noise", BIOMES, 8, PRE_FEATURES, Type.PROTOCHUNK, (var02, var1, var2, var3, var4, var5, var6, var7, var8) -> {
        RegionLimitedWorldAccess var9 = new RegionLimitedWorldAccess(var2, var7, var02, 0);
        return var3.fillFromNoise(var1, Blender.of(var9), var2.getChunkSource().randomState(), var2.structureManager().forWorldGenRegion(var9), var8).thenApply(var0 -> {
            ProtoChunk var1;
            BelowZeroRetrogen var2;
            if (var0 instanceof ProtoChunk && (var2 = (var1 = (ProtoChunk)var0).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock(var1);
                if (var2.hasBedrockHoles()) {
                    var2.applyBedrockMask((ProtoChunk)((Object)var1));
                }
            }
            return Either.left((Object)var0);
        });
    });
    public static final ChunkStatus SURFACE = ChunkStatus.registerSimple("surface", NOISE, 8, PRE_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var1, var3, var0, 0);
        var2.buildSurface(var5, var1.structureManager().forWorldGenRegion(var5), var1.getChunkSource().randomState(), var4);
    });
    public static final ChunkStatus CARVERS = ChunkStatus.registerSimple("carvers", SURFACE, 8, POST_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var1, var3, var0, 0);
        if (var4 instanceof ProtoChunk) {
            ProtoChunk var6 = (ProtoChunk)var4;
            Blender.addAroundOldChunksCarvingMaskFilter(var5, var6);
        }
        var2.applyCarvers(var5, var1.getSeed(), var1.getChunkSource().randomState(), var1.getBiomeManager(), var1.structureManager().forWorldGenRegion(var5), var4, WorldGenStage.Features.AIR);
    });
    public static final ChunkStatus FEATURES = ChunkStatus.registerSimple("features", CARVERS, 8, POST_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {
        HeightMap.primeHeightmaps(var4, EnumSet.of(HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE));
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var1, var3, var0, 1);
        var2.applyBiomeDecoration(var5, var4, var1.structureManager().forWorldGenRegion(var5));
        Blender.generateBorderTicks(var5, var4);
    });
    public static final ChunkStatus INITIALIZE_LIGHT = ChunkStatus.register("initialize_light", FEATURES, 0, false, POST_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4, var5, var6, var7, var8) -> ChunkStatus.initializeLight(var5, var8), (var0, var1, var2, var3, var4, var5) -> ChunkStatus.initializeLight(var3, var5));
    public static final ChunkStatus LIGHT = ChunkStatus.register("light", INITIALIZE_LIGHT, 1, true, POST_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4, var5, var6, var7, var8) -> ChunkStatus.lightChunk(var5, var8), (var0, var1, var2, var3, var4, var5) -> ChunkStatus.lightChunk(var3, var5));
    public static final ChunkStatus SPAWN = ChunkStatus.registerSimple("spawn", LIGHT, 0, POST_FEATURES, Type.PROTOCHUNK, (var0, var1, var2, var3, var4) -> {
        if (!var4.isUpgrading()) {
            var2.spawnOriginalMobs(new RegionLimitedWorldAccess(var1, var3, var0, -1));
        }
    });
    public static final ChunkStatus FULL = ChunkStatus.register("full", SPAWN, 0, false, POST_FEATURES, Type.LEVELCHUNK, (var0, var1, var2, var3, var4, var5, var6, var7, var8) -> (CompletableFuture)var6.apply(var8), (var0, var1, var2, var3, var4, var5) -> (CompletableFuture)var4.apply(var5));
    private static final List<ChunkStatus> STATUS_BY_RANGE = ImmutableList.of((Object)FULL, (Object)INITIALIZE_LIGHT, (Object)CARVERS, (Object)BIOMES, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object[])new ChunkStatus[0]);
    private static final IntList RANGE_BY_STATUS = (IntList)SystemUtils.make(new IntArrayList(ChunkStatus.getStatusList().size()), var0 -> {
        int var1 = 0;
        for (int var2 = ChunkStatus.getStatusList().size() - 1; var2 >= 0; --var2) {
            while (var1 + 1 < STATUS_BY_RANGE.size() && var2 <= STATUS_BY_RANGE.get(var1 + 1).getIndex()) {
                ++var1;
            }
            var0.add(0, var1);
        }
    });
    private final int index;
    private final ChunkStatus parent;
    private final b generationTask;
    private final c loadingTask;
    private final int range;
    private final boolean hasLoadDependencies;
    private final Type chunkType;
    private final EnumSet<HeightMap.Type> heightmapsAfter;

    private static CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> initializeLight(LightEngineThreaded var0, IChunkAccess var1) {
        var1.initializeLightSources();
        ((ProtoChunk)var1).setLightEngine(var0);
        boolean var2 = ChunkStatus.isLighted(var1);
        return var0.initializeLight(var1, var2).thenApply(Either::left);
    }

    private static CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> lightChunk(LightEngineThreaded var0, IChunkAccess var1) {
        boolean var2 = ChunkStatus.isLighted(var1);
        return var0.lightChunk(var1, var2).thenApply(Either::left);
    }

    private static ChunkStatus registerSimple(String var0, @Nullable ChunkStatus var1, int var2, EnumSet<HeightMap.Type> var3, Type var4, d var5) {
        return ChunkStatus.register(var0, var1, var2, var3, var4, var5);
    }

    private static ChunkStatus register(String var0, @Nullable ChunkStatus var1, int var2, EnumSet<HeightMap.Type> var3, Type var4, b var5) {
        return ChunkStatus.register(var0, var1, var2, false, var3, var4, var5, PASSTHROUGH_LOAD_TASK);
    }

    private static ChunkStatus register(String var0, @Nullable ChunkStatus var1, int var2, boolean var3, EnumSet<HeightMap.Type> var4, Type var5, b var6, c var7) {
        return IRegistry.register(BuiltInRegistries.CHUNK_STATUS, var0, new ChunkStatus(var1, var2, var3, var4, var5, var6, var7));
    }

    public static List<ChunkStatus> getStatusList() {
        ChunkStatus var1;
        ArrayList var0 = Lists.newArrayList();
        for (var1 = FULL; var1.getParent() != var1; var1 = var1.getParent()) {
            var0.add(var1);
        }
        var0.add(var1);
        Collections.reverse(var0);
        return var0;
    }

    private static boolean isLighted(IChunkAccess var0) {
        return var0.getStatus().isOrAfter(LIGHT) && var0.isLightCorrect();
    }

    public static ChunkStatus getStatusAroundFullChunk(int var0) {
        if (var0 >= STATUS_BY_RANGE.size()) {
            return EMPTY;
        }
        if (var0 < 0) {
            return FULL;
        }
        return STATUS_BY_RANGE.get(var0);
    }

    public static int maxDistance() {
        return STATUS_BY_RANGE.size();
    }

    public static int getDistance(ChunkStatus var0) {
        return RANGE_BY_STATUS.getInt(var0.getIndex());
    }

    ChunkStatus(@Nullable ChunkStatus var0, int var1, boolean var2, EnumSet<HeightMap.Type> var3, Type var4, b var5, c var6) {
        this.parent = var0 == null ? this : var0;
        this.generationTask = var5;
        this.loadingTask = var6;
        this.range = var1;
        this.hasLoadDependencies = var2;
        this.chunkType = var4;
        this.heightmapsAfter = var3;
        this.index = var0 == null ? 0 : var0.getIndex() + 1;
    }

    public int getIndex() {
        return this.index;
    }

    public ChunkStatus getParent() {
        return this.parent;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> generate(Executor var0, WorldServer var12, ChunkGenerator var2, StructureTemplateManager var3, LightEngineThreaded var4, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var5, List<IChunkAccess> var6) {
        IChunkAccess var7 = var6.get(var6.size() / 2);
        ProfiledDuration var8 = JvmProfiler.INSTANCE.onChunkGenerate(var7.getPos(), var12.dimension(), this.toString());
        return this.generationTask.doWork(this, var0, var12, var2, var3, var4, var5, var6, var7).thenApply(var1 -> {
            var1.ifLeft(var0 -> {
                ProtoChunk var1;
                if (var0 instanceof ProtoChunk && !(var1 = (ProtoChunk)var0).getStatus().isOrAfter(this)) {
                    var1.setStatus(this);
                }
            });
            if (var8 != null) {
                var8.finish();
            }
            return var1;
        });
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> load(WorldServer var0, StructureTemplateManager var1, LightEngineThreaded var2, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var3, IChunkAccess var4) {
        return this.loadingTask.doWork(this, var0, var1, var2, var3, var4);
    }

    public int getRange() {
        return this.range;
    }

    public boolean hasLoadDependencies() {
        return this.hasLoadDependencies;
    }

    public Type getChunkType() {
        return this.chunkType;
    }

    public static ChunkStatus byName(String var0) {
        return BuiltInRegistries.CHUNK_STATUS.get(MinecraftKey.tryParse(var0));
    }

    public EnumSet<HeightMap.Type> heightmapsAfter() {
        return this.heightmapsAfter;
    }

    public boolean isOrAfter(ChunkStatus var0) {
        return this.getIndex() >= var0.getIndex();
    }

    public String toString() {
        return BuiltInRegistries.CHUNK_STATUS.getKey(this).toString();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PROTOCHUNK = new Type();
        public static final /* enum */ Type LEVELCHUNK = new Type();
        private static final /* synthetic */ Type[] c;

        public static Type[] values() {
            return (Type[])c.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{PROTOCHUNK, LEVELCHUNK};
        }

        static {
            c = Type.a();
        }
    }

    static interface b {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, Executor var2, WorldServer var3, ChunkGenerator var4, StructureTemplateManager var5, LightEngineThreaded var6, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var7, List<IChunkAccess> var8, IChunkAccess var9);
    }

    static interface c {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, WorldServer var2, StructureTemplateManager var3, LightEngineThreaded var4, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var5, IChunkAccess var6);
    }

    static interface d
    extends b {
        @Override
        default public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var0, Executor var1, WorldServer var2, ChunkGenerator var3, StructureTemplateManager var4, LightEngineThreaded var5, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var6, List<IChunkAccess> var7, IChunkAccess var8) {
            this.doWork(var0, var2, var3, var7, var8);
            return CompletableFuture.completedFuture(Either.left((Object)var8));
        }

        public void doWork(ChunkStatus var1, WorldServer var2, ChunkGenerator var3, List<IChunkAccess> var4, IChunkAccess var5);
    }
}

