/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListServer;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final TickingBlockEntity NULL_TICKER = new TickingBlockEntity(){

        @Override
        public void tick() {
        }

        @Override
        public boolean isRemoved() {
            return true;
        }

        @Override
        public BlockPosition getPos() {
            return BlockPosition.ZERO;
        }

        @Override
        public String getType() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> tickersInLevel = Maps.newHashMap();
    public boolean loaded;
    public final World level;
    @Nullable
    private Supplier<FullChunkStatus> fullStatus;
    @Nullable
    private c postLoad;
    private final Int2ObjectMap<GameEventListenerRegistry> gameEventListenerRegistrySections;
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<FluidType> fluidTicks;

    public Chunk(World var0, ChunkCoordIntPair var1) {
        this(var0, var1, ChunkConverter.EMPTY, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World var0, ChunkCoordIntPair var1, ChunkConverter var2, LevelChunkTicks<Block> var3, LevelChunkTicks<FluidType> var4, long var5, @Nullable ChunkSection[] var7, @Nullable c var8, @Nullable BlendingData var9) {
        super(var1, var2, var0, var0.registryAccess().registryOrThrow(Registries.BIOME), var5, var7, var9);
        this.level = var0;
        this.gameEventListenerRegistrySections = new Int2ObjectOpenHashMap();
        for (HeightMap.Type var13 : HeightMap.Type.values()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(var13)) continue;
            this.heightmaps.put(var13, new HeightMap(this, var13));
        }
        this.postLoad = var8;
        this.blockTicks = var3;
        this.fluidTicks = var4;
    }

    public Chunk(WorldServer var0, ProtoChunk var1, @Nullable c var2) {
        this(var0, var1.getPos(), var1.getUpgradeData(), var1.unpackBlockTicks(), var1.unpackFluidTicks(), var1.getInhabitedTime(), var1.getSections(), var2, var1.getBlendingData());
        for (TileEntity tileEntity : var1.getBlockEntities().values()) {
            this.setBlockEntity(tileEntity);
        }
        this.pendingBlockEntities.putAll(var1.getBlockEntityNbts());
        for (int var3 = 0; var3 < var1.getPostProcessing().length; ++var3) {
            this.postProcessing[var3] = var1.getPostProcessing()[var3];
        }
        this.setAllStarts(var1.getAllStarts());
        this.setAllReferences(var1.getAllReferences());
        for (Map.Entry<HeightMap.Type, HeightMap> entry : var1.getHeightmaps()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(entry.getKey())) continue;
            this.setHeightmap(entry.getKey(), entry.getValue().getRawData());
        }
        this.skyLightSources = var1.skyLightSources;
        this.setLightCorrect(var1.isLightCorrect());
        this.unsaved = true;
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public IChunkAccess.a getTicksForSerialization() {
        return new IChunkAccess.a(this.blockTicks, this.fluidTicks);
    }

    @Override
    public GameEventListenerRegistry getListenerRegistry(int var0) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            return (GameEventListenerRegistry)this.gameEventListenerRegistrySections.computeIfAbsent(var0, var2 -> new EuclideanGameEventListenerRegistry(var1, var0, this::removeGameEventListenerRegistry));
        }
        return super.getListenerRegistry(var0);
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        int var1 = var0.getX();
        int var2 = var0.getY();
        int var3 = var0.getZ();
        if (this.level.isDebug()) {
            IBlockData var4 = null;
            if (var2 == 60) {
                var4 = Blocks.BARRIER.defaultBlockState();
            }
            if (var2 == 70) {
                var4 = ChunkProviderDebug.getBlockStateFor(var1, var3);
            }
            return var4 == null ? Blocks.AIR.defaultBlockState() : var4;
        }
        try {
            ChunkSection var5;
            int var4 = this.getSectionIndex(var2);
            if (var4 >= 0 && var4 < this.sections.length && !(var5 = this.sections[var4]).hasOnlyAir()) {
                return var5.getBlockState(var1 & 0xF, var2 & 0xF, var3 & 0xF);
            }
            return Blocks.AIR.defaultBlockState();
        }
        catch (Throwable var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Getting block state");
            CrashReportSystemDetails var6 = var5.addCategory("Block being got");
            var6.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, var1, var2, var3));
            throw new ReportedException(var5);
        }
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        return this.getFluidState(var0.getX(), var0.getY(), var0.getZ());
    }

    public Fluid getFluidState(int var0, int var1, int var2) {
        try {
            ChunkSection var4;
            int var3 = this.getSectionIndex(var1);
            if (var3 >= 0 && var3 < this.sections.length && !(var4 = this.sections[var3]).hasOnlyAir()) {
                return var4.getFluidState(var0 & 0xF, var1 & 0xF, var2 & 0xF);
            }
            return FluidTypes.EMPTY.defaultFluidState();
        }
        catch (Throwable var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Getting fluid state");
            CrashReportSystemDetails var5 = var4.addCategory("Block being got");
            var5.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, var0, var1, var2));
            throw new ReportedException(var4);
        }
    }

    @Override
    @Nullable
    public IBlockData setBlockState(BlockPosition var0, IBlockData var1, boolean var2) {
        int var8;
        int var7;
        int var3 = var0.getY();
        ChunkSection var4 = this.getSection(this.getSectionIndex(var3));
        boolean var5 = var4.hasOnlyAir();
        if (var5 && var1.isAir()) {
            return null;
        }
        int var6 = var0.getX() & 0xF;
        IBlockData var9 = var4.setBlockState(var6, var7 = var3 & 0xF, var8 = var0.getZ() & 0xF, var1);
        if (var9 == var1) {
            return null;
        }
        Block var10 = var1.getBlock();
        ((HeightMap)this.heightmaps.get(HeightMap.Type.MOTION_BLOCKING)).update(var6, var3, var8, var1);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES)).update(var6, var3, var8, var1);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.OCEAN_FLOOR)).update(var6, var3, var8, var1);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.WORLD_SURFACE)).update(var6, var3, var8, var1);
        boolean var11 = var4.hasOnlyAir();
        if (var5 != var11) {
            this.level.getChunkSource().getLightEngine().updateSectionStatus(var0, var11);
        }
        if (LightEngine.hasDifferentLightProperties(this, var0, var9, var1)) {
            GameProfilerFiller var12 = this.level.getProfiler();
            var12.push("updateSkyLightSources");
            this.skyLightSources.update(this, var6, var3, var8);
            var12.popPush("queueCheckLight");
            this.level.getChunkSource().getLightEngine().checkBlock(var0);
            var12.pop();
        }
        boolean var12 = var9.hasBlockEntity();
        if (!this.level.isClientSide) {
            var9.onRemove(this.level, var0, var1, var2);
        } else if (!var9.is(var10) && var12) {
            this.removeBlockEntity(var0);
        }
        if (!var4.getBlockState(var6, var7, var8).is(var10)) {
            return null;
        }
        if (!this.level.isClientSide) {
            var1.onPlace(this.level, var0, var9, var2);
        }
        if (var1.hasBlockEntity()) {
            TileEntity var13 = this.getBlockEntity(var0, EnumTileEntityState.CHECK);
            if (var13 == null) {
                var13 = ((ITileEntity)((Object)var10)).newBlockEntity(var0, var1);
                if (var13 != null) {
                    this.addAndRegisterBlockEntity(var13);
                }
            } else {
                var13.setBlockState(var1);
                this.updateBlockEntityTicker(var13);
            }
        }
        this.unsaved = true;
        return var9;
    }

    @Override
    @Deprecated
    public void addEntity(Entity var0) {
    }

    @Nullable
    private TileEntity createBlockEntity(BlockPosition var0) {
        IBlockData var1 = this.getBlockState(var0);
        if (!var1.hasBlockEntity()) {
            return null;
        }
        return ((ITileEntity)((Object)var1.getBlock())).newBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return this.getBlockEntity(var0, EnumTileEntityState.CHECK);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0, EnumTileEntityState var1) {
        TileEntity var4;
        NBTTagCompound var3;
        TileEntity var2 = (TileEntity)this.blockEntities.get(var0);
        if (var2 == null && (var3 = (NBTTagCompound)this.pendingBlockEntities.remove(var0)) != null && (var4 = this.promotePendingBlockEntity(var0, var3)) != null) {
            return var4;
        }
        if (var2 == null) {
            if (var1 == EnumTileEntityState.IMMEDIATE && (var2 = this.createBlockEntity(var0)) != null) {
                this.addAndRegisterBlockEntity(var2);
            }
        } else if (var2.isRemoved()) {
            this.blockEntities.remove(var0);
            return null;
        }
        return var2;
    }

    public void addAndRegisterBlockEntity(TileEntity var0) {
        this.setBlockEntity(var0);
        if (this.isInLevel()) {
            World world = this.level;
            if (world instanceof WorldServer) {
                WorldServer var1 = (WorldServer)world;
                this.addGameEventListener(var0, var1);
            }
            this.updateBlockEntityTicker(var0);
        }
    }

    private boolean isInLevel() {
        return this.loaded || this.level.isClientSide();
    }

    boolean isTicking(BlockPosition var0) {
        if (!this.level.getWorldBorder().isWithinBounds(var0)) {
            return false;
        }
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            return this.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING) && var1.areEntitiesLoaded(ChunkCoordIntPair.asLong(var0));
        }
        return true;
    }

    @Override
    public void setBlockEntity(TileEntity var0) {
        BlockPosition var1 = var0.getBlockPos();
        if (!this.getBlockState(var1).hasBlockEntity()) {
            return;
        }
        var0.setLevel(this.level);
        var0.clearRemoved();
        TileEntity var2 = this.blockEntities.put(var1.immutable(), var0);
        if (var2 != null && var2 != var0) {
            var2.setRemoved();
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var0) {
        TileEntity var1 = this.getBlockEntity(var0);
        if (var1 != null && !var1.isRemoved()) {
            NBTTagCompound var2 = var1.saveWithFullMetadata();
            var2.putBoolean("keepPacked", false);
            return var2;
        }
        NBTTagCompound var2 = (NBTTagCompound)this.pendingBlockEntities.get(var0);
        if (var2 != null) {
            var2 = var2.copy();
            var2.putBoolean("keepPacked", true);
        }
        return var2;
    }

    @Override
    public void removeBlockEntity(BlockPosition var0) {
        TileEntity var1;
        if (this.isInLevel() && (var1 = (TileEntity)this.blockEntities.remove(var0)) != null) {
            World world = this.level;
            if (world instanceof WorldServer) {
                WorldServer var2 = (WorldServer)world;
                this.removeGameEventListener(var1, var2);
            }
            var1.setRemoved();
        }
        this.removeBlockEntityTicker(var0);
    }

    private <T extends TileEntity> void removeGameEventListener(T var0, WorldServer var1) {
        GameEventListener var3;
        Block var2 = var0.getBlockState().getBlock();
        if (var2 instanceof ITileEntity && (var3 = ((ITileEntity)((Object)var2)).getListener(var1, var0)) != null) {
            int var4 = SectionPosition.blockToSectionCoord(var0.getBlockPos().getY());
            GameEventListenerRegistry var5 = this.getListenerRegistry(var4);
            var5.unregister(var3);
        }
    }

    private void removeGameEventListenerRegistry(int var0) {
        this.gameEventListenerRegistrySections.remove(var0);
    }

    private void removeBlockEntityTicker(BlockPosition var0) {
        d var1 = this.tickersInLevel.remove(var0);
        if (var1 != null) {
            var1.rebind(NULL_TICKER);
        }
    }

    public void runPostLoad() {
        if (this.postLoad != null) {
            this.postLoad.run(this);
            this.postLoad = null;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void replaceWithPacketData(PacketDataSerializer var02, NBTTagCompound var12, Consumer<ClientboundLevelChunkPacketData.b> var22) {
        this.clearAllBlockEntities();
        for (ChunkSection chunkSection : this.sections) {
            chunkSection.read(var02);
        }
        for (HeightMap.Type type : HeightMap.Type.values()) {
            String var7 = type.getSerializationKey();
            if (!var12.contains(var7, 12)) continue;
            this.setHeightmap(type, var12.getLongArray(var7));
        }
        this.initializeLightSources();
        var22.accept((var0, var1, var2) -> {
            TileEntity var3 = this.getBlockEntity(var0, EnumTileEntityState.IMMEDIATE);
            if (var3 != null && var2 != null && var3.getType() == var1) {
                var3.load(var2);
            }
        });
    }

    public void replaceBiomes(PacketDataSerializer var0) {
        for (ChunkSection var4 : this.sections) {
            var4.readBiomes(var0);
        }
    }

    public void setLoaded(boolean var0) {
        this.loaded = var0;
    }

    public World getLevel() {
        return this.level;
    }

    public Map<BlockPosition, TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void postProcessGeneration() {
        ChunkCoordIntPair var0 = this.getPos();
        for (int var1 = 0; var1 < this.postProcessing.length; ++var1) {
            if (this.postProcessing[var1] == null) continue;
            for (Short var3 : this.postProcessing[var1]) {
                BlockPosition var4 = ProtoChunk.unpackOffsetCoordinates(var3, this.getSectionYFromSectionIndex(var1), var0);
                IBlockData var5 = this.getBlockState(var4);
                Fluid var6 = var5.getFluidState();
                if (!var6.isEmpty()) {
                    var6.tick(this.level, var4);
                }
                if (var5.getBlock() instanceof BlockFluids) continue;
                IBlockData var7 = Block.updateFromNeighbourShapes(var5, this.level, var4);
                this.level.setBlock(var4, var7, 20);
            }
            this.postProcessing[var1].clear();
        }
        for (BlockPosition var2 : ImmutableList.copyOf(this.pendingBlockEntities.keySet())) {
            this.getBlockEntity(var2);
        }
        this.pendingBlockEntities.clear();
        this.upgradeData.upgrade(this);
    }

    @Nullable
    private TileEntity promotePendingBlockEntity(BlockPosition var0, NBTTagCompound var1) {
        TileEntity var2;
        IBlockData var3 = this.getBlockState(var0);
        if ("DUMMY".equals(var1.getString("id"))) {
            if (var3.hasBlockEntity()) {
                var2 = ((ITileEntity)((Object)var3.getBlock())).newBlockEntity(var0, var3);
            } else {
                var2 = null;
                LOGGER.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)var0, (Object)var3);
            }
        } else {
            var2 = TileEntity.loadStatic(var0, var3, var1);
        }
        if (var2 != null) {
            var2.setLevel(this.level);
            this.addAndRegisterBlockEntity(var2);
        } else {
            LOGGER.warn("Tried to load a block entity for block {} but failed at location {}", (Object)var3, (Object)var0);
        }
        return var2;
    }

    public void unpackTicks(long var0) {
        this.blockTicks.unpack(var0);
        this.fluidTicks.unpack(var0);
    }

    public void registerTickContainerInLevel(WorldServer var0) {
        ((TickListServer)var0.getBlockTicks()).addContainer(this.chunkPos, this.blockTicks);
        ((TickListServer)var0.getFluidTicks()).addContainer(this.chunkPos, this.fluidTicks);
    }

    public void unregisterTickContainerFromLevel(WorldServer var0) {
        ((TickListServer)var0.getBlockTicks()).removeContainer(this.chunkPos);
        ((TickListServer)var0.getFluidTicks()).removeContainer(this.chunkPos);
    }

    @Override
    public ChunkStatus getStatus() {
        return ChunkStatus.FULL;
    }

    public FullChunkStatus getFullStatus() {
        if (this.fullStatus == null) {
            return FullChunkStatus.FULL;
        }
        return this.fullStatus.get();
    }

    public void setFullStatus(Supplier<FullChunkStatus> var0) {
        this.fullStatus = var0;
    }

    public void clearAllBlockEntities() {
        this.blockEntities.values().forEach(TileEntity::setRemoved);
        this.blockEntities.clear();
        this.tickersInLevel.values().forEach(var0 -> var0.rebind(NULL_TICKER));
        this.tickersInLevel.clear();
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
        this.blockEntities.values().forEach(var0 -> {
            World var2 = this.level;
            if (var2 instanceof WorldServer) {
                WorldServer var1 = (WorldServer)var2;
                this.addGameEventListener(var0, var1);
            }
            this.updateBlockEntityTicker(var0);
        });
    }

    private <T extends TileEntity> void addGameEventListener(T var0, WorldServer var1) {
        GameEventListener var3;
        Block var2 = var0.getBlockState().getBlock();
        if (var2 instanceof ITileEntity && (var3 = ((ITileEntity)((Object)var2)).getListener(var1, var0)) != null) {
            this.getListenerRegistry(SectionPosition.blockToSectionCoord(var0.getBlockPos().getY())).register(var3);
        }
    }

    private <T extends TileEntity> void updateBlockEntityTicker(T var0) {
        IBlockData var1 = var0.getBlockState();
        BlockEntityTicker<?> var22 = var1.getTicker(this.level, var0.getType());
        if (var22 == null) {
            this.removeBlockEntityTicker(var0.getBlockPos());
        } else {
            this.tickersInLevel.compute(var0.getBlockPos(), (var2, var3) -> {
                TickingBlockEntity var4 = this.createTicker(var0, var22);
                if (var3 != null) {
                    var3.rebind(var4);
                    return var3;
                }
                if (this.isInLevel()) {
                    d var5 = new d(var4);
                    this.level.addBlockEntityTicker(var5);
                    return var5;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity createTicker(T var0, BlockEntityTicker<T> var1) {
        return new a(var0, var1);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    public static final class EnumTileEntityState
    extends Enum<EnumTileEntityState> {
        public static final /* enum */ EnumTileEntityState IMMEDIATE = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState QUEUED = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState CHECK = new EnumTileEntityState();
        private static final /* synthetic */ EnumTileEntityState[] d;

        public static EnumTileEntityState[] values() {
            return (EnumTileEntityState[])d.clone();
        }

        public static EnumTileEntityState valueOf(String var0) {
            return Enum.valueOf(EnumTileEntityState.class, var0);
        }

        private static /* synthetic */ EnumTileEntityState[] a() {
            return new EnumTileEntityState[]{IMMEDIATE, QUEUED, CHECK};
        }

        static {
            d = EnumTileEntityState.a();
        }
    }

    class d
    implements TickingBlockEntity {
        private TickingBlockEntity ticker;

        d(TickingBlockEntity var1) {
            this.ticker = var1;
        }

        void rebind(TickingBlockEntity var0) {
            this.ticker = var0;
        }

        @Override
        public void tick() {
            this.ticker.tick();
        }

        @Override
        public boolean isRemoved() {
            return this.ticker.isRemoved();
        }

        @Override
        public BlockPosition getPos() {
            return this.ticker.getPos();
        }

        @Override
        public String getType() {
            return this.ticker.getType();
        }

        public String toString() {
            return this.ticker.toString() + " <wrapped>";
        }
    }

    class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T blockEntity;
        private final BlockEntityTicker<T> ticker;
        private boolean loggedInvalidBlockState;

        a(TileEntity var1, BlockEntityTicker var2) {
            this.blockEntity = var1;
            this.ticker = var2;
        }

        @Override
        public void tick() {
            BlockPosition var0;
            if (!((TileEntity)this.blockEntity).isRemoved() && ((TileEntity)this.blockEntity).hasLevel() && Chunk.this.isTicking(var0 = ((TileEntity)this.blockEntity).getBlockPos())) {
                try {
                    GameProfilerFiller var1 = Chunk.this.level.getProfiler();
                    var1.push(this::getType);
                    IBlockData var2 = Chunk.this.getBlockState(var0);
                    if (((TileEntity)this.blockEntity).getType().isValid(var2)) {
                        this.ticker.tick(Chunk.this.level, ((TileEntity)this.blockEntity).getBlockPos(), var2, this.blockEntity);
                        this.loggedInvalidBlockState = false;
                    } else if (!this.loggedInvalidBlockState) {
                        this.loggedInvalidBlockState = true;
                        LOGGER.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::getType), LogUtils.defer(this::getPos), var2});
                    }
                    var1.pop();
                }
                catch (Throwable var1) {
                    CrashReport var2 = CrashReport.forThrowable(var1, "Ticking block entity");
                    CrashReportSystemDetails var3 = var2.addCategory("Block entity being ticked");
                    ((TileEntity)this.blockEntity).fillCrashReportCategory(var3);
                    throw new ReportedException(var2);
                }
            }
        }

        @Override
        public boolean isRemoved() {
            return ((TileEntity)this.blockEntity).isRemoved();
        }

        @Override
        public BlockPosition getPos() {
            return ((TileEntity)this.blockEntity).getBlockPos();
        }

        @Override
        public String getType() {
            return TileEntityTypes.getKey(((TileEntity)this.blockEntity).getType()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.getType() + "@" + this.getPos();
        }
    }
}

