/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;

public class TileEntityChest
extends TileEntityLootable
implements LidBlockEntity {
    private static final int EVENT_SET_OPEN_COUNT = 1;
    private NonNullList<ItemStack> items = NonNullList.withSize(27, ItemStack.EMPTY);
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(World var0, BlockPosition var1, IBlockData var2) {
            TileEntityChest.playSound(var0, var1, var2, SoundEffects.CHEST_OPEN);
        }

        @Override
        protected void onClose(World var0, BlockPosition var1, IBlockData var2) {
            TileEntityChest.playSound(var0, var1, var2, SoundEffects.CHEST_CLOSE);
        }

        @Override
        protected void openerCountChanged(World var0, BlockPosition var1, IBlockData var2, int var3, int var4) {
            TileEntityChest.this.signalOpenCount(var0, var1, var2, var3, var4);
        }

        @Override
        protected boolean isOwnContainer(EntityHuman var0) {
            if (var0.containerMenu instanceof ContainerChest) {
                IInventory var1 = ((ContainerChest)var0.containerMenu).getContainer();
                return var1 == TileEntityChest.this || var1 instanceof InventoryLargeChest && ((InventoryLargeChest)var1).contains(TileEntityChest.this);
            }
            return false;
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();

    protected TileEntityChest(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    public TileEntityChest(BlockPosition var0, IBlockData var1) {
        this(TileEntityTypes.CHEST, var0, var1);
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.chest");
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items);
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items);
        }
    }

    public static void lidAnimateTick(World var0, BlockPosition var1, IBlockData var2, TileEntityChest var3) {
        var3.chestLidController.tickLid();
    }

    public static void playSound(World var0, BlockPosition var1, IBlockData var2, SoundEffect var3) {
        BlockPropertyChestType var4 = var2.getValue(BlockChest.TYPE);
        if (var4 == BlockPropertyChestType.LEFT) {
            return;
        }
        double var5 = (double)var1.getX() + 0.5;
        double var7 = (double)var1.getY() + 0.5;
        double var9 = (double)var1.getZ() + 0.5;
        if (var4 == BlockPropertyChestType.RIGHT) {
            EnumDirection var11 = BlockChest.getConnectedDirection(var2);
            var5 += (double)var11.getStepX() * 0.5;
            var9 += (double)var11.getStepZ() * 0.5;
        }
        var0.playSound(null, var5, var7, var9, var3, SoundCategory.BLOCKS, 0.5f, var0.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.chestLidController.shouldBeOpen(var1 > 0);
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.incrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.decrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    public float getOpenNess(float var0) {
        return this.chestLidController.getOpenness(var0);
    }

    public static int getOpenCount(IBlockAccess var0, BlockPosition var1) {
        TileEntity var3;
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.hasBlockEntity() && (var3 = var0.getBlockEntity(var1)) instanceof TileEntityChest) {
            return ((TileEntityChest)var3).openersCounter.getOpenerCount();
        }
        return 0;
    }

    public static void swapContents(TileEntityChest var0, TileEntityChest var1) {
        NonNullList<ItemStack> var2 = var0.getItems();
        var0.setItems(var1.getItems());
        var1.setItems(var2);
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return ContainerChest.threeRows(var0, var1, this);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(World var0, BlockPosition var1, IBlockData var2, int var3, int var4) {
        Block var5 = var2.getBlock();
        var0.blockEvent(var1, var5, 1, var4);
    }
}

