/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnumColor;

public class EnumBannerPatternType {
    final String hashname;

    public EnumBannerPatternType(String var0) {
        this.hashname = var0;
    }

    public static MinecraftKey location(ResourceKey<EnumBannerPatternType> var0, boolean var1) {
        String var2 = var1 ? "banner" : "shield";
        return var0.location().withPrefix("entity/" + var2 + "/");
    }

    public String getHashname() {
        return this.hashname;
    }

    @Nullable
    public static Holder<EnumBannerPatternType> byHash(String var0) {
        return BuiltInRegistries.BANNER_PATTERN.holders().filter(var1 -> ((EnumBannerPatternType)var1.value()).hashname.equals(var0)).findAny().orElse(null);
    }

    public static class a {
        private final List<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns = Lists.newArrayList();

        public a addPattern(ResourceKey<EnumBannerPatternType> var0, EnumColor var1) {
            return this.addPattern(BuiltInRegistries.BANNER_PATTERN.getHolderOrThrow(var0), var1);
        }

        public a addPattern(Holder<EnumBannerPatternType> var0, EnumColor var1) {
            return this.addPattern((Pair<Holder<EnumBannerPatternType>, EnumColor>)Pair.of(var0, (Object)var1));
        }

        public a addPattern(Pair<Holder<EnumBannerPatternType>, EnumColor> var0) {
            this.patterns.add(var0);
            return this;
        }

        public NBTTagList toListTag() {
            NBTTagList var0 = new NBTTagList();
            for (Pair<Holder<EnumBannerPatternType>, EnumColor> var2 : this.patterns) {
                NBTTagCompound var3 = new NBTTagCompound();
                var3.putString("Pattern", ((EnumBannerPatternType)((Holder)var2.getFirst()).value()).hashname);
                var3.putInt("Color", ((EnumColor)var2.getSecond()).getId());
                var0.add(var3);
            }
            return var0;
        }
    }
}

