/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;

    protected abstract void onOpen(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void onClose(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void openerCountChanged(World var1, BlockPosition var2, IBlockData var3, int var4, int var5);

    protected abstract boolean isOwnContainer(EntityHuman var1);

    public void incrementOpeners(EntityHuman var0, World var1, BlockPosition var2, IBlockData var3) {
        int var4;
        if ((var4 = this.openCount++) == 0) {
            this.onOpen(var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.CONTAINER_OPEN, var2);
            ContainerOpenersCounter.scheduleRecheck(var1, var2, var3);
        }
        this.openerCountChanged(var1, var2, var3, var4, this.openCount);
    }

    public void decrementOpeners(EntityHuman var0, World var1, BlockPosition var2, IBlockData var3) {
        int var4 = this.openCount--;
        if (this.openCount == 0) {
            this.onClose(var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.CONTAINER_CLOSE, var2);
        }
        this.openerCountChanged(var1, var2, var3, var4, this.openCount);
    }

    private int getOpenCount(World var0, BlockPosition var1) {
        int var2 = var1.getX();
        int var3 = var1.getY();
        int var4 = var1.getZ();
        float var5 = 5.0f;
        AxisAlignedBB var6 = new AxisAlignedBB((float)var2 - 5.0f, (float)var3 - 5.0f, (float)var4 - 5.0f, (float)(var2 + 1) + 5.0f, (float)(var3 + 1) + 5.0f, (float)(var4 + 1) + 5.0f);
        return var0.getEntities(EntityTypeTest.forClass(EntityHuman.class), var6, this::isOwnContainer).size();
    }

    public void recheckOpeners(World var0, BlockPosition var1, IBlockData var2) {
        int var4 = this.openCount;
        int var3 = this.getOpenCount(var0, var1);
        if (var4 != var3) {
            boolean var6;
            boolean var5 = var3 != 0;
            boolean bl = var6 = var4 != 0;
            if (var5 && !var6) {
                this.onOpen(var0, var1, var2);
                var0.gameEvent(null, GameEvent.CONTAINER_OPEN, var1);
            } else if (!var5) {
                this.onClose(var0, var1, var2);
                var0.gameEvent(null, GameEvent.CONTAINER_CLOSE, var1);
            }
            this.openCount = var3;
        }
        this.openerCountChanged(var0, var1, var2, var4, var3);
        if (var3 > 0) {
            ContainerOpenersCounter.scheduleRecheck(var0, var1, var2);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(World var0, BlockPosition var1, IBlockData var2) {
        var0.scheduleTick(var1, var2.getBlock(), 5);
    }
}

