/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class SculkShriekerBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean SHRIEKING = BlockProperties.SHRIEKING;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateBoolean CAN_SUMMON = BlockProperties.CAN_SUMMON;
    protected static final VoxelShape COLLIDER = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final double TOP_Y = COLLIDER.max(EnumDirection.EnumAxis.Y);

    public SculkShriekerBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(SHRIEKING, false)).setValue(WATERLOGGED, false)).setValue(CAN_SUMMON, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(SHRIEKING);
        var0.add(WATERLOGGED);
        var0.add(CAN_SUMMON);
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var22, Entity var3) {
        if (var0 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var0;
            EntityPlayer var5 = SculkShriekerBlockEntity.tryGetPlayer(var3);
            if (var5 != null) {
                var4.getBlockEntity(var1, TileEntityTypes.SCULK_SHRIEKER).ifPresent(var2 -> var2.tryShriek(var4, var5));
            }
        }
        super.stepOn(var0, var1, var22, var3);
    }

    @Override
    public void onRemove(IBlockData var0, World var12, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var12 instanceof WorldServer) {
            WorldServer var5 = (WorldServer)var12;
            if (var0.getValue(SHRIEKING).booleanValue() && !var0.is(var3.getBlock())) {
                var5.getBlockEntity(var2, TileEntityTypes.SCULK_SHRIEKER).ifPresent(var1 -> var1.tryRespond(var5));
            }
        }
        super.onRemove(var0, var12, var2, var3, var4);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var12, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(SHRIEKING).booleanValue()) {
            var12.setBlock(var2, (IBlockData)var0.setValue(SHRIEKING, false), 3);
            var12.getBlockEntity(var2, TileEntityTypes.SCULK_SHRIEKER).ifPresent(var1 -> var1.tryRespond(var12));
        }
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return COLLIDER;
    }

    @Override
    public VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return COLLIDER;
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new SculkShriekerBlockEntity(var0, var1);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var0.getLevel().getFluidState(var0.getClickedPos()).getType() == FluidTypes.WATER);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var4) {
            this.tryDropExperience(var1, var2, var3, ConstantInt.of(5));
        }
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var02, IBlockData var12, TileEntityTypes<T> var22) {
        if (!var02.isClientSide) {
            return BlockTileEntity.createTickerHelper(var22, TileEntityTypes.SCULK_SHRIEKER, (var0, var1, var2, var3) -> VibrationSystem.c.tick(var0, var3.getVibrationData(), var3.getVibrationUser()));
        }
        return null;
    }
}

