/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTurtleEgg
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape ONE_EGG_AABB = Block.box(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.box(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final BlockStateInteger HATCH = BlockProperties.HATCH;
    public static final BlockStateInteger EGGS = BlockProperties.EGGS;

    public BlockTurtleEgg(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HATCH, 0)).setValue(EGGS, 1));
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        if (!var3.isSteppingCarefully()) {
            this.destroyEgg(var0, var2, var1, var3, 100);
        }
        super.stepOn(var0, var1, var2, var3);
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, float var4) {
        if (!(var3 instanceof EntityZombie)) {
            this.destroyEgg(var0, var1, var2, var3, 3);
        }
        super.fallOn(var0, var1, var2, var3, var4);
    }

    private void destroyEgg(World var0, IBlockData var1, BlockPosition var2, Entity var3, int var4) {
        if (!this.canDestroyEgg(var0, var3)) {
            return;
        }
        if (!var0.isClientSide && var0.random.nextInt(var4) == 0 && var1.is(Blocks.TURTLE_EGG)) {
            this.decreaseEggs(var0, var2, var1);
        }
    }

    private void decreaseEggs(World var0, BlockPosition var1, IBlockData var2) {
        var0.playSound(null, var1, SoundEffects.TURTLE_EGG_BREAK, SoundCategory.BLOCKS, 0.7f, 0.9f + var0.random.nextFloat() * 0.2f);
        int var3 = var2.getValue(EGGS);
        if (var3 <= 1) {
            var0.destroyBlock(var1, false);
        } else {
            var0.setBlock(var1, (IBlockData)var2.setValue(EGGS, var3 - 1), 2);
            var0.gameEvent(GameEvent.BLOCK_DESTROY, var1, GameEvent.a.of(var2));
            var0.levelEvent(2001, var1, Block.getId(var2));
        }
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (this.shouldUpdateHatchLevel(var1) && BlockTurtleEgg.onSand(var1, var2)) {
            int var4 = var0.getValue(HATCH);
            if (var4 < 2) {
                var1.playSound(null, var2, SoundEffects.TURTLE_EGG_CRACK, SoundCategory.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
                var1.setBlock(var2, (IBlockData)var0.setValue(HATCH, var4 + 1), 2);
            } else {
                var1.playSound(null, var2, SoundEffects.TURTLE_EGG_HATCH, SoundCategory.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
                var1.removeBlock(var2, false);
                for (int var5 = 0; var5 < var0.getValue(EGGS); ++var5) {
                    var1.levelEvent(2001, var2, Block.getId(var0));
                    EntityTurtle var6 = EntityTypes.TURTLE.create(var1);
                    if (var6 == null) continue;
                    var6.setAge(-24000);
                    var6.setHomePos(var2);
                    var6.moveTo((double)var2.getX() + 0.3 + (double)var5 * 0.2, var2.getY(), (double)var2.getZ() + 0.3, 0.0f, 0.0f);
                    var1.addFreshEntity(var6);
                }
            }
        }
    }

    public static boolean onSand(IBlockAccess var0, BlockPosition var1) {
        return BlockTurtleEgg.isSand(var0, var1.below());
    }

    public static boolean isSand(IBlockAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1).is(TagsBlock.SAND);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (BlockTurtleEgg.onSand(var1, var2) && !var1.isClientSide) {
            var1.levelEvent(2005, var2, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(World var0) {
        float var1 = var0.getTimeOfDay(1.0f);
        if ((double)var1 < 0.69 && (double)var1 > 0.65) {
            return true;
        }
        return var0.random.nextInt(500) == 0;
    }

    @Override
    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        super.playerDestroy(var0, var1, var2, var3, var4, var5);
        this.decreaseEggs(var0, var2, var3);
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().is(this.asItem()) && var0.getValue(EGGS) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (IBlockData)var1.setValue(EGGS, Math.min(4, var1.getValue(EGGS) + 1));
        }
        return super.getStateForPlacement(var0);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var0.getValue(EGGS) > 1) {
            return MULTIPLE_EGGS_AABB;
        }
        return ONE_EGG_AABB;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HATCH, EGGS);
    }

    private boolean canDestroyEgg(World var0, Entity var1) {
        if (var1 instanceof EntityTurtle || var1 instanceof EntityBat) {
            return false;
        }
        if (var1 instanceof EntityLiving) {
            return var1 instanceof EntityHuman || var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
        return false;
    }
}

