/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class BlockTarget
extends Block {
    private static final BlockStateInteger OUTPUT_POWER = BlockProperties.POWER;
    private static final int ACTIVATION_TICKS_ARROWS = 20;
    private static final int ACTIVATION_TICKS_OTHER = 8;

    public BlockTarget(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(OUTPUT_POWER, 0));
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        int var4 = BlockTarget.updateRedstoneOutput(var0, var1, var2, var3);
        Entity var5 = var3.getOwner();
        if (var5 instanceof EntityPlayer) {
            EntityPlayer var6 = (EntityPlayer)var5;
            var6.awardStat(StatisticList.TARGET_HIT);
            CriterionTriggers.TARGET_BLOCK_HIT.trigger(var6, var3, var2.getLocation(), var4);
        }
    }

    private static int updateRedstoneOutput(GeneratorAccess var0, IBlockData var1, MovingObjectPositionBlock var2, Entity var3) {
        int var5;
        int var4 = BlockTarget.getRedstoneStrength(var2, var2.getLocation());
        int n2 = var5 = var3 instanceof EntityArrow ? 20 : 8;
        if (!var0.getBlockTicks().hasScheduledTick(var2.getBlockPos(), var1.getBlock())) {
            BlockTarget.setOutputPower(var0, var1, var4, var2.getBlockPos(), var5);
        }
        return var4;
    }

    private static int getRedstoneStrength(MovingObjectPositionBlock var0, Vec3D var1) {
        EnumDirection var2 = var0.getDirection();
        double var3 = Math.abs(MathHelper.frac(var1.x) - 0.5);
        double var5 = Math.abs(MathHelper.frac(var1.y) - 0.5);
        double var7 = Math.abs(MathHelper.frac(var1.z) - 0.5);
        EnumDirection.EnumAxis var11 = var2.getAxis();
        double var9 = var11 == EnumDirection.EnumAxis.Y ? Math.max(var3, var7) : (var11 == EnumDirection.EnumAxis.Z ? Math.max(var3, var5) : Math.max(var5, var7));
        return Math.max(1, MathHelper.ceil(15.0 * MathHelper.clamp((0.5 - var9) / 0.5, 0.0, 1.0)));
    }

    private static void setOutputPower(GeneratorAccess var0, IBlockData var1, int var2, BlockPosition var3, int var4) {
        var0.setBlock(var3, (IBlockData)var1.setValue(OUTPUT_POWER, var2), 3);
        var0.scheduleTick(var3, var1.getBlock(), var4);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(OUTPUT_POWER) != 0) {
            var1.setBlock(var2, (IBlockData)var0.setValue(OUTPUT_POWER, 0), 3);
        }
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(OUTPUT_POWER);
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(OUTPUT_POWER);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var1.isClientSide() || var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(OUTPUT_POWER) > 0 && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(OUTPUT_POWER, 0), 18);
        }
    }
}

