/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockSweetBerryBush
extends BlockPlant
implements IBlockFragilePlantElement {
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final BlockStateInteger AGE = BlockProperties.AGE_3;
    private static final VoxelShape SAPLING_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public BlockSweetBerryBush(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Items.SWEET_BERRIES);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var0.getValue(AGE) == 0) {
            return SAPLING_SHAPE;
        }
        if (var0.getValue(AGE) < 3) {
            return MID_GROWTH_SHAPE;
        }
        return super.getShape(var0, var1, var2, var3);
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 3;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(AGE);
        if (var4 < 3 && var3.nextInt(5) == 0 && var1.getRawBrightness(var2.above(), 0) >= 9) {
            IBlockData var5 = (IBlockData)var0.setValue(AGE, var4 + 1);
            var1.setBlock(var2, var5, 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var5));
        }
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (!(var3 instanceof EntityLiving) || var3.getType() == EntityTypes.FOX || var3.getType() == EntityTypes.BEE) {
            return;
        }
        var3.makeStuckInBlock(var0, new Vec3D(0.8f, 0.75, 0.8f));
        if (!(var1.isClientSide || var0.getValue(AGE) <= 0 || var3.xOld == var3.getX() && var3.zOld == var3.getZ())) {
            double var4 = Math.abs(var3.getX() - var3.xOld);
            double var6 = Math.abs(var3.getZ() - var3.zOld);
            if (var4 >= (double)0.003f || var6 >= (double)0.003f) {
                var3.hurt(var1.damageSources().sweetBerryBush(), 1.0f);
            }
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        boolean var7;
        int var6 = var0.getValue(AGE);
        boolean bl = var7 = var6 == 3;
        if (!var7 && var3.getItemInHand(var4).is(Items.BONE_MEAL)) {
            return EnumInteractionResult.PASS;
        }
        if (var6 > 1) {
            int var8 = 1 + var1.random.nextInt(2);
            BlockSweetBerryBush.popResource(var1, var2, new ItemStack(Items.SWEET_BERRIES, var8 + (var7 ? 1 : 0)));
            var1.playSound(null, var2, SoundEffects.SWEET_BERRY_BUSH_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, 0.8f + var1.random.nextFloat() * 0.4f);
            IBlockData var9 = (IBlockData)var0.setValue(AGE, 1);
            var1.setBlock(var2, var9, 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var9));
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return super.use(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return var2.getValue(AGE) < 3;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = Math.min(3, var3.getValue(AGE) + 1);
        var0.setBlock(var2, (IBlockData)var3.setValue(AGE, var4), 2);
    }
}

