/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSlowSand
extends Block {
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 14.0, 16.0);
    private static final int BUBBLE_COLUMN_CHECK_DELAY = 20;

    public BlockSlowSand(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.block();
    }

    @Override
    public VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.block();
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockBubbleColumn.updateColumn(var1, var2.above(), var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && var2.is(Blocks.WATER)) {
            var3.scheduleTick(var4, this, 20);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, 20);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public float getShadeBrightness(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return 0.2f;
    }
}

