/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockPressurePlateAbstract
extends Block {
    protected static final VoxelShape PRESSED_AABB = Block.box(1.0, 0.0, 1.0, 15.0, 0.5, 15.0);
    protected static final VoxelShape AABB = Block.box(1.0, 0.0, 1.0, 15.0, 1.0, 15.0);
    protected static final AxisAlignedBB TOUCH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375);
    private final BlockSetType type;

    protected BlockPressurePlateAbstract(BlockBase.Info var0, BlockSetType var1) {
        super(var0.sound(var1.soundType()));
        this.type = var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getSignalForState(var0) > 0 ? PRESSED_AABB : AABB;
    }

    protected int getPressedTime() {
        return 20;
    }

    @Override
    public boolean isPossibleToRespawnInThis(IBlockData var0) {
        return true;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        return BlockPressurePlateAbstract.canSupportRigidBlock(var1, var3) || BlockPressurePlateAbstract.canSupportCenter(var1, var3, EnumDirection.UP);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = this.getSignalForState(var0);
        if (var4 > 0) {
            this.checkPressed(null, var1, var2, var0, var4);
        }
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var1.isClientSide) {
            return;
        }
        int var4 = this.getSignalForState(var0);
        if (var4 == 0) {
            this.checkPressed(var3, var1, var2, var0, var4);
        }
    }

    private void checkPressed(@Nullable Entity var0, World var1, BlockPosition var2, IBlockData var3, int var4) {
        boolean var7;
        int var5 = this.getSignalStrength(var1, var2);
        boolean var6 = var4 > 0;
        boolean bl = var7 = var5 > 0;
        if (var4 != var5) {
            IBlockData var8 = this.setSignalForState(var3, var5);
            var1.setBlock(var2, var8, 2);
            this.updateNeighbours(var1, var2);
            var1.setBlocksDirty(var2, var3, var8);
        }
        if (!var7 && var6) {
            var1.playSound(null, var2, this.type.pressurePlateClickOff(), SoundCategory.BLOCKS);
            var1.gameEvent(var0, GameEvent.BLOCK_DEACTIVATE, var2);
        } else if (var7 && !var6) {
            var1.playSound(null, var2, this.type.pressurePlateClickOn(), SoundCategory.BLOCKS);
            var1.gameEvent(var0, GameEvent.BLOCK_ACTIVATE, var2);
        }
        if (var7) {
            var1.scheduleTick(new BlockPosition(var2), this, this.getPressedTime());
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4 || var0.is(var3.getBlock())) {
            return;
        }
        if (this.getSignalForState(var0) > 0) {
            this.updateNeighbours(var1, var2);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    protected void updateNeighbours(World var0, BlockPosition var1) {
        var0.updateNeighborsAt(var1, this);
        var0.updateNeighborsAt(var1.below(), this);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return this.getSignalForState(var0);
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var3 == EnumDirection.UP) {
            return this.getSignalForState(var0);
        }
        return 0;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    protected static int getEntityCount(World var02, AxisAlignedBB var1, Class<? extends Entity> var2) {
        return var02.getEntitiesOfClass(var2, var1, IEntitySelector.NO_SPECTATORS.and(var0 -> !var0.isIgnoringBlockTriggers())).size();
    }

    protected abstract int getSignalStrength(World var1, BlockPosition var2);

    protected abstract int getSignalForState(IBlockData var1);

    protected abstract IBlockData setSignalForState(IBlockData var1, int var2);
}

