/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDirtSnowSpreadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BlockGrass
extends BlockDirtSnowSpreadable
implements IBlockFragilePlantElement {
    public BlockGrass(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return var0.getBlockState(var1.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        BlockPosition var4 = var2.above();
        IBlockData var5 = Blocks.GRASS.defaultBlockState();
        Optional<Holder.c<PlacedFeature>> var6 = var0.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int var7 = 0; var7 < 128; ++var7) {
            Holder<PlacedFeature> var10;
            BlockPosition var8 = var4;
            for (int var9 = 0; var9 < var7 / 16; ++var9) {
                if (!var0.getBlockState((var8 = var8.offset(var1.nextInt(3) - 1, (var1.nextInt(3) - 1) * var1.nextInt(3) / 2, var1.nextInt(3) - 1)).below()).is(this) || var0.getBlockState(var8).isCollisionShapeFullBlock(var0, var8)) continue block0;
            }
            IBlockData var9 = var0.getBlockState(var8);
            if (var9.is(var5.getBlock()) && var1.nextInt(10) == 0) {
                ((IBlockFragilePlantElement)((Object)var5.getBlock())).performBonemeal(var0, var1, var8, var9);
            }
            if (!var9.isAir()) continue;
            if (var1.nextInt(8) == 0) {
                List<WorldGenFeatureConfigured<?, ?>> var11 = var0.getBiome(var8).value().getGenerationSettings().getFlowerFeatures();
                if (var11.isEmpty()) continue;
                var10 = ((WorldGenFeatureRandomPatchConfiguration)var11.get(0).config()).feature();
            } else {
                if (!var6.isPresent()) continue;
                var10 = (Holder<PlacedFeature>)var6.get();
            }
            ((PlacedFeature)var10.value()).place(var0, var0.getChunkSource().getGenerator(), var1, var8);
        }
    }
}

