/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.Position;
import net.minecraft.core.SourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockDispenser
extends BlockTileEntity {
    public static final BlockStateDirection FACING = BlockDirectional.FACING;
    public static final BlockStateBoolean TRIGGERED = BlockProperties.TRIGGERED;
    public static final Map<Item, IDispenseBehavior> DISPENSER_REGISTRY = (Map)SystemUtils.make(new Object2ObjectOpenHashMap(), var0 -> var0.defaultReturnValue((Object)new DispenseBehaviorItem()));
    private static final int TRIGGER_DURATION = 4;

    public static void registerBehavior(IMaterial var0, IDispenseBehavior var1) {
        DISPENSER_REGISTRY.put(var0.asItem(), var1);
    }

    protected BlockDispenser(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(TRIGGERED, false));
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        TileEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof TileEntityDispenser) {
            var3.openMenu((TileEntityDispenser)var6);
            if (var6 instanceof TileEntityDropper) {
                var3.awardStat(StatisticList.INSPECT_DROPPER);
            } else {
                var3.awardStat(StatisticList.INSPECT_DISPENSER);
            }
        }
        return EnumInteractionResult.CONSUME;
    }

    public void dispenseFrom(WorldServer var0, BlockPosition var1) {
        SourceBlock var2 = new SourceBlock(var0, var1);
        TileEntityDispenser var3 = (TileEntityDispenser)var2.getEntity();
        int var4 = var3.getRandomSlot(var0.random);
        if (var4 < 0) {
            var0.levelEvent(1001, var1, 0);
            var0.gameEvent(GameEvent.BLOCK_ACTIVATE, var1, GameEvent.a.of(var3.getBlockState()));
            return;
        }
        ItemStack var5 = var3.getItem(var4);
        IDispenseBehavior var6 = this.getDispenseMethod(var5);
        if (var6 != IDispenseBehavior.NOOP) {
            var3.setItem(var4, var6.dispense(var2, var5));
        }
    }

    protected IDispenseBehavior getDispenseMethod(ItemStack var0) {
        return DISPENSER_REGISTRY.get(var0.getItem());
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2) || var1.hasNeighborSignal(var2.above());
        boolean var7 = var0.getValue(TRIGGERED);
        if (var6 && !var7) {
            var1.scheduleTick(var2, this, 4);
            var1.setBlock(var2, (IBlockData)var0.setValue(TRIGGERED, true), 4);
        } else if (!var6 && var7) {
            var1.setBlock(var2, (IBlockData)var0.setValue(TRIGGERED, false), 4);
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.dispenseFrom(var1, var2);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityDispenser(var0, var1);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getNearestLookingDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        TileEntity var5;
        if (var4.hasCustomHoverName() && (var5 = var0.getBlockEntity(var1)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)var5).setCustomName(var4.getHoverName());
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityDispenser) {
            InventoryUtils.dropContents(var1, var2, (IInventory)((TileEntityDispenser)var5));
            var1.updateNeighbourForOutputSignal(var2, this);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    public static IPosition getDispensePosition(ISourceBlock var0) {
        EnumDirection var1 = var0.getBlockState().getValue(FACING);
        double var2 = var0.x() + 0.7 * (double)var1.getStepX();
        double var4 = var0.y() + 0.7 * (double)var1.getStepY();
        double var6 = var0.z() + 0.7 * (double)var1.getStepZ();
        return new Position(var2, var4, var6);
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, TRIGGERED);
    }
}

