/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockDaylightDetector
extends BlockTileEntity {
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    public static final BlockStateBoolean INVERTED = BlockProperties.INVERTED;
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);

    public BlockDaylightDetector(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWER, 0)).setValue(INVERTED, false));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWER);
    }

    private static void updateSignalStrength(IBlockData var0, World var1, BlockPosition var2) {
        int var3 = var1.getBrightness(EnumSkyBlock.SKY, var2) - var1.getSkyDarken();
        float var4 = var1.getSunAngle(1.0f);
        boolean var5 = var0.getValue(INVERTED);
        if (var5) {
            var3 = 15 - var3;
        } else if (var3 > 0) {
            float var6 = var4 < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            var4 += (var6 - var4) * 0.2f;
            var3 = Math.round((float)var3 * MathHelper.cos(var4));
        }
        var3 = MathHelper.clamp(var3, 0, 15);
        if (var0.getValue(POWER) != var3) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWER, var3), 3);
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var3.mayBuild()) {
            if (var1.isClientSide) {
                return EnumInteractionResult.SUCCESS;
            }
            IBlockData var6 = (IBlockData)var0.cycle(INVERTED);
            var1.setBlock(var2, var6, 4);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var6));
            BlockDaylightDetector.updateSignalStrength(var6, var1, var2);
            return EnumInteractionResult.CONSUME;
        }
        return super.use(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityLightDetector(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (!var0.isClientSide && var0.dimensionType().hasSkyLight()) {
            return BlockDaylightDetector.createTickerHelper(var2, TileEntityTypes.DAYLIGHT_DETECTOR, BlockDaylightDetector::tickEntity);
        }
        return null;
    }

    private static void tickEntity(World var0, BlockPosition var1, IBlockData var2, TileEntityLightDetector var3) {
        if (var0.getGameTime() % 20L == 0L) {
            BlockDaylightDetector.updateSignalStrength(var2, var0, var1);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWER, INVERTED);
    }
}

