/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.pathfinder.PathMode;

public class BlockChorusFruit
extends BlockSprawling {
    protected BlockChorusFruit(BlockBase.Info var0) {
        super(0.3125f, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false)).setValue(DOWN, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.getStateForPlacement(var0.getLevel(), var0.getClickedPos());
    }

    public IBlockData getStateForPlacement(IBlockAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1.below());
        IBlockData var3 = var0.getBlockState(var1.above());
        IBlockData var4 = var0.getBlockState(var1.north());
        IBlockData var5 = var0.getBlockState(var1.east());
        IBlockData var6 = var0.getBlockState(var1.south());
        IBlockData var7 = var0.getBlockState(var1.west());
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(DOWN, var2.is(this) || var2.is(Blocks.CHORUS_FLOWER) || var2.is(Blocks.END_STONE))).setValue(UP, var3.is(this) || var3.is(Blocks.CHORUS_FLOWER))).setValue(NORTH, var4.is(this) || var4.is(Blocks.CHORUS_FLOWER))).setValue(EAST, var5.is(this) || var5.is(Blocks.CHORUS_FLOWER))).setValue(SOUTH, var6.is(this) || var6.is(Blocks.CHORUS_FLOWER))).setValue(WEST, var7.is(this) || var7.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
            return super.updateShape(var0, var1, var2, var3, var4, var5);
        }
        boolean var6 = var2.is(this) || var2.is(Blocks.CHORUS_FLOWER) || var1 == EnumDirection.DOWN && var2.is(Blocks.END_STONE);
        return (IBlockData)var0.setValue((IBlockState)PROPERTY_BY_DIRECTION.get(var1), var6);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        boolean var4 = !var1.getBlockState(var2.above()).isAir() && !var3.isAir();
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var7 = var2.relative(var6);
            IBlockData var8 = var1.getBlockState(var7);
            if (!var8.is(this)) continue;
            if (var4) {
                return false;
            }
            IBlockData var9 = var1.getBlockState(var7.below());
            if (!var9.is(this) && !var9.is(Blocks.END_STONE)) continue;
            return true;
        }
        return var3.is(this) || var3.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

