/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;

public class MerchantRecipe {
    public ItemStack baseCostA;
    public ItemStack costB;
    public final ItemStack result;
    public int uses;
    public int maxUses;
    public boolean rewardExp = true;
    public int specialPriceDiff;
    public int demand;
    public float priceMultiplier;
    public int xp = 1;

    public MerchantRecipe(NBTTagCompound var0) {
        this.baseCostA = ItemStack.of(var0.getCompound("buy"));
        this.costB = ItemStack.of(var0.getCompound("buyB"));
        this.result = ItemStack.of(var0.getCompound("sell"));
        this.uses = var0.getInt("uses");
        this.maxUses = var0.contains("maxUses", 99) ? var0.getInt("maxUses") : 4;
        if (var0.contains("rewardExp", 1)) {
            this.rewardExp = var0.getBoolean("rewardExp");
        }
        if (var0.contains("xp", 3)) {
            this.xp = var0.getInt("xp");
        }
        if (var0.contains("priceMultiplier", 5)) {
            this.priceMultiplier = var0.getFloat("priceMultiplier");
        }
        this.specialPriceDiff = var0.getInt("specialPrice");
        this.demand = var0.getInt("demand");
    }

    public MerchantRecipe(ItemStack var0, ItemStack var1, int var2, int var3, float var4) {
        this(var0, ItemStack.EMPTY, var1, var2, var3, var4);
    }

    public MerchantRecipe(ItemStack var0, ItemStack var1, ItemStack var2, int var3, int var4, float var5) {
        this(var0, var1, var2, 0, var3, var4, var5);
    }

    public MerchantRecipe(ItemStack var0, ItemStack var1, ItemStack var2, int var3, int var4, int var5, float var6) {
        this(var0, var1, var2, var3, var4, var5, var6, 0);
    }

    public MerchantRecipe(ItemStack var0, ItemStack var1, ItemStack var2, int var3, int var4, int var5, float var6, int var7) {
        this.baseCostA = var0;
        this.costB = var1;
        this.result = var2;
        this.uses = var3;
        this.maxUses = var4;
        this.xp = var5;
        this.priceMultiplier = var6;
        this.demand = var7;
    }

    public ItemStack getBaseCostA() {
        return this.baseCostA;
    }

    public ItemStack getCostA() {
        if (this.baseCostA.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int var0 = this.baseCostA.getCount();
        int var1 = Math.max(0, MathHelper.floor((float)(var0 * this.demand) * this.priceMultiplier));
        return this.baseCostA.copyWithCount(MathHelper.clamp(var0 + var1 + this.specialPriceDiff, 1, this.baseCostA.getItem().getMaxStackSize()));
    }

    public ItemStack getCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void updateDemand() {
        this.demand = this.demand + this.uses - (this.maxUses - this.uses);
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public int getUses() {
        return this.uses;
    }

    public void resetUses() {
        this.uses = 0;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void increaseUses() {
        ++this.uses;
    }

    public int getDemand() {
        return this.demand;
    }

    public void addToSpecialPriceDiff(int var0) {
        this.specialPriceDiff += var0;
    }

    public void resetSpecialPriceDiff() {
        this.specialPriceDiff = 0;
    }

    public int getSpecialPriceDiff() {
        return this.specialPriceDiff;
    }

    public void setSpecialPriceDiff(int var0) {
        this.specialPriceDiff = var0;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isOutOfStock() {
        return this.uses >= this.maxUses;
    }

    public void setToOutOfStock() {
        this.uses = this.maxUses;
    }

    public boolean needsRestock() {
        return this.uses > 0;
    }

    public boolean shouldRewardExp() {
        return this.rewardExp;
    }

    public NBTTagCompound createTag() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.put("buy", this.baseCostA.save(new NBTTagCompound()));
        var0.put("sell", this.result.save(new NBTTagCompound()));
        var0.put("buyB", this.costB.save(new NBTTagCompound()));
        var0.putInt("uses", this.uses);
        var0.putInt("maxUses", this.maxUses);
        var0.putBoolean("rewardExp", this.rewardExp);
        var0.putInt("xp", this.xp);
        var0.putFloat("priceMultiplier", this.priceMultiplier);
        var0.putInt("specialPrice", this.specialPriceDiff);
        var0.putInt("demand", this.demand);
        return var0;
    }

    public boolean satisfiedBy(ItemStack var0, ItemStack var1) {
        return this.isRequiredItem(var0, this.getCostA()) && var0.getCount() >= this.getCostA().getCount() && this.isRequiredItem(var1, this.costB) && var1.getCount() >= this.costB.getCount();
    }

    private boolean isRequiredItem(ItemStack var0, ItemStack var1) {
        if (var1.isEmpty() && var0.isEmpty()) {
            return true;
        }
        ItemStack var2 = var0.copy();
        if (var2.getItem().canBeDepleted()) {
            var2.setDamageValue(var2.getDamageValue());
        }
        return ItemStack.isSameItem(var2, var1) && (!var1.hasTag() || var2.hasTag() && GameProfileSerializer.compareNbt(var1.getTag(), var2.getTag(), false));
    }

    public boolean take(ItemStack var0, ItemStack var1) {
        if (!this.satisfiedBy(var0, var1)) {
            return false;
        }
        var0.shrink(this.getCostA().getCount());
        if (!this.getCostB().isEmpty()) {
            var1.shrink(this.getCostB().getCount());
        }
        return true;
    }
}

