/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;

public class SmithingTransformRecipe
implements SmithingRecipe {
    private final MinecraftKey id;
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final ItemStack result;

    public SmithingTransformRecipe(MinecraftKey var0, RecipeItemStack var1, RecipeItemStack var2, RecipeItemStack var3, ItemStack var4) {
        this.id = var0;
        this.template = var1;
        this.base = var2;
        this.addition = var3;
        this.result = var4;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.template.test(var0.getItem(0)) && this.base.test(var0.getItem(1)) && this.addition.test(var0.getItem(2));
    }

    @Override
    public ItemStack assemble(IInventory var0, IRegistryCustom var1) {
        ItemStack var2 = this.result.copy();
        NBTTagCompound var3 = var0.getItem(1).getTag();
        if (var3 != null) {
            var2.setTag(var3.copy());
        }
        return var2;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack var0) {
        return this.template.test(var0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack var0) {
        return this.base.test(var0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        @Override
        public SmithingTransformRecipe fromJson(MinecraftKey var0, JsonObject var1) {
            RecipeItemStack var2 = RecipeItemStack.fromJson(ChatDeserializer.getNonNull(var1, "template"));
            RecipeItemStack var3 = RecipeItemStack.fromJson(ChatDeserializer.getNonNull(var1, "base"));
            RecipeItemStack var4 = RecipeItemStack.fromJson(ChatDeserializer.getNonNull(var1, "addition"));
            ItemStack var5 = ShapedRecipes.itemStackFromJson(ChatDeserializer.getAsJsonObject(var1, "result"));
            return new SmithingTransformRecipe(var0, var2, var3, var4, var5);
        }

        @Override
        public SmithingTransformRecipe fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            RecipeItemStack var2 = RecipeItemStack.fromNetwork(var1);
            RecipeItemStack var3 = RecipeItemStack.fromNetwork(var1);
            RecipeItemStack var4 = RecipeItemStack.fromNetwork(var1);
            ItemStack var5 = var1.readItem();
            return new SmithingTransformRecipe(var0, var2, var3, var4, var5);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, SmithingTransformRecipe var1) {
            var1.template.toNetwork(var0);
            var1.base.toNetwork(var0);
            var1.addition.toNetwork(var0);
            var0.writeItem(var1.result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }
    }
}

