/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;

public class ShapelessRecipes
implements RecipeCrafting {
    private final MinecraftKey id;
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<RecipeItemStack> ingredients;

    public ShapelessRecipes(MinecraftKey var0, String var1, CraftingBookCategory var2, ItemStack var3, NonNullList<RecipeItemStack> var4) {
        this.id = var0;
        this.group = var1;
        this.category = var2;
        this.result = var3;
        this.ingredients = var4;
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        AutoRecipeStackManager var2 = new AutoRecipeStackManager();
        int var3 = 0;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            ++var3;
            var2.accountStack(var5, 1);
        }
        return var3 == this.ingredients.size() && var2.canCraft(this, null);
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= this.ingredients.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        @Override
        public ShapelessRecipes fromJson(MinecraftKey var0, JsonObject var1) {
            String var2 = ChatDeserializer.getAsString(var1, "group", "");
            CraftingBookCategory var3 = CraftingBookCategory.CODEC.byName(ChatDeserializer.getAsString(var1, "category", null), CraftingBookCategory.MISC);
            NonNullList<RecipeItemStack> var4 = a.itemsFromJson(ChatDeserializer.getAsJsonArray(var1, "ingredients"));
            if (var4.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (var4.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack var5 = ShapedRecipes.itemStackFromJson(ChatDeserializer.getAsJsonObject(var1, "result"));
            return new ShapelessRecipes(var0, var2, var3, var5, var4);
        }

        private static NonNullList<RecipeItemStack> itemsFromJson(JsonArray var0) {
            NonNullList<RecipeItemStack> var1 = NonNullList.create();
            for (int var2 = 0; var2 < var0.size(); ++var2) {
                RecipeItemStack var3 = RecipeItemStack.fromJson(var0.get(var2), false);
                if (var3.isEmpty()) continue;
                var1.add(var3);
            }
            return var1;
        }

        @Override
        public ShapelessRecipes fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            String var2 = var1.readUtf();
            CraftingBookCategory var3 = var1.readEnum(CraftingBookCategory.class);
            int var4 = var1.readVarInt();
            NonNullList<RecipeItemStack> var5 = NonNullList.withSize(var4, RecipeItemStack.EMPTY);
            for (int var6 = 0; var6 < var5.size(); ++var6) {
                var5.set(var6, RecipeItemStack.fromNetwork(var1));
            }
            ItemStack var6 = var1.readItem();
            return new ShapelessRecipes(var0, var2, var3, var6, var5);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, ShapelessRecipes var1) {
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            var0.writeVarInt(var1.ingredients.size());
            for (RecipeItemStack var3 : var1.ingredients) {
                var3.toNetwork(var0);
            }
            var0.writeItem(var1.result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }
    }
}

