/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class ShapedRecipes
implements RecipeCrafting {
    final int width;
    final int height;
    final NonNullList<RecipeItemStack> recipeItems;
    final ItemStack result;
    private final MinecraftKey id;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedRecipes(MinecraftKey var0, String var1, CraftingBookCategory var2, int var3, int var4, NonNullList<RecipeItemStack> var5, ItemStack var6, boolean var7) {
        this.id = var0;
        this.group = var1;
        this.category = var2;
        this.width = var3;
        this.height = var4;
        this.recipeItems = var5;
        this.result = var6;
        this.showNotification = var7;
    }

    public ShapedRecipes(MinecraftKey var0, String var1, CraftingBookCategory var2, int var3, int var4, NonNullList<RecipeItemStack> var5, ItemStack var6) {
        this(var0, var1, var2, var3, var4, var5, var6, true);
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.recipeItems;
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= this.width && var1 >= this.height;
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        for (int var2 = 0; var2 <= var0.getWidth() - this.width; ++var2) {
            for (int var3 = 0; var3 <= var0.getHeight() - this.height; ++var3) {
                if (this.matches(var0, var2, var3, true)) {
                    return true;
                }
                if (!this.matches(var0, var2, var3, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(InventoryCrafting var0, int var1, int var2, boolean var3) {
        for (int var4 = 0; var4 < var0.getWidth(); ++var4) {
            for (int var5 = 0; var5 < var0.getHeight(); ++var5) {
                int var6 = var4 - var1;
                int var7 = var5 - var2;
                RecipeItemStack var8 = RecipeItemStack.EMPTY;
                if (var6 >= 0 && var7 >= 0 && var6 < this.width && var7 < this.height) {
                    var8 = var3 ? this.recipeItems.get(this.width - var6 - 1 + var7 * this.width) : this.recipeItems.get(var6 + var7 * this.width);
                }
                if (var8.test(var0.getItem(var4 + var5 * var0.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        return this.getResultItem(var1).copy();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static NonNullList<RecipeItemStack> dissolvePattern(String[] var0, Map<String, RecipeItemStack> var1, int var2, int var3) {
        NonNullList<RecipeItemStack> var4 = NonNullList.withSize(var2 * var3, RecipeItemStack.EMPTY);
        HashSet var5 = Sets.newHashSet(var1.keySet());
        var5.remove(" ");
        for (int var6 = 0; var6 < var0.length; ++var6) {
            for (int var7 = 0; var7 < var0[var6].length(); ++var7) {
                String var8 = var0[var6].substring(var7, var7 + 1);
                RecipeItemStack var9 = var1.get(var8);
                if (var9 == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + var8 + "' but it's not defined in the key");
                }
                var5.remove(var8);
                var4.set(var7 + var2 * var6, var9);
            }
        }
        if (!var5.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + var5);
        }
        return var4;
    }

    @VisibleForTesting
    static String[] shrink(String ... var0) {
        int var1 = Integer.MAX_VALUE;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (int var5 = 0; var5 < var0.length; ++var5) {
            String var6 = var0[var5];
            var1 = Math.min(var1, ShapedRecipes.firstNonSpace(var6));
            int var7 = ShapedRecipes.lastNonSpace(var6);
            var2 = Math.max(var2, var7);
            if (var7 < 0) {
                if (var3 == var5) {
                    ++var3;
                }
                ++var4;
                continue;
            }
            var4 = 0;
        }
        if (var0.length == var4) {
            return new String[0];
        }
        String[] var5 = new String[var0.length - var4 - var3];
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = var0[var6 + var3].substring(var1, var2 + 1);
        }
        return var5;
    }

    @Override
    public boolean isIncomplete() {
        NonNullList<RecipeItemStack> var02 = this.getIngredients();
        return var02.isEmpty() || var02.stream().filter(var0 -> !var0.isEmpty()).anyMatch(var0 -> var0.getItems().length == 0);
    }

    private static int firstNonSpace(String var0) {
        int var1;
        for (var1 = 0; var1 < var0.length() && var0.charAt(var1) == ' '; ++var1) {
        }
        return var1;
    }

    private static int lastNonSpace(String var0) {
        int var1;
        for (var1 = var0.length() - 1; var1 >= 0 && var0.charAt(var1) == ' '; --var1) {
        }
        return var1;
    }

    static String[] patternFromJson(JsonArray var0) {
        String[] var1 = new String[var0.size()];
        if (var1.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (var1.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int var2 = 0; var2 < var1.length; ++var2) {
            String var3 = ChatDeserializer.convertToString(var0.get(var2), "pattern[" + var2 + "]");
            if (var3.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (var2 > 0 && var1[0].length() != var3.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            var1[var2] = var3;
        }
        return var1;
    }

    static Map<String, RecipeItemStack> keyFromJson(JsonObject var0) {
        HashMap var1 = Maps.newHashMap();
        for (Map.Entry var3 : var0.entrySet()) {
            if (((String)var3.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)var3.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(var3.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            var1.put((String)var3.getKey(), RecipeItemStack.fromJson((JsonElement)var3.getValue(), false));
        }
        var1.put(" ", RecipeItemStack.EMPTY);
        return var1;
    }

    public static ItemStack itemStackFromJson(JsonObject var0) {
        Item var1 = ShapedRecipes.itemFromJson(var0);
        if (var0.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int var2 = ChatDeserializer.getAsInt(var0, "count", 1);
        if (var2 < 1) {
            throw new JsonSyntaxException("Invalid output count: " + var2);
        }
        return new ItemStack(var1, var2);
    }

    public static Item itemFromJson(JsonObject var0) {
        String var1 = ChatDeserializer.getAsString(var0, "item");
        Item var2 = (Item)BuiltInRegistries.ITEM.getOptional(MinecraftKey.tryParse(var1)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + var1 + "'"));
        if (var2 == Items.AIR) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return var2;
    }

    public static class a
    implements RecipeSerializer<ShapedRecipes> {
        @Override
        public ShapedRecipes fromJson(MinecraftKey var0, JsonObject var1) {
            String var2 = ChatDeserializer.getAsString(var1, "group", "");
            CraftingBookCategory var3 = CraftingBookCategory.CODEC.byName(ChatDeserializer.getAsString(var1, "category", null), CraftingBookCategory.MISC);
            Map<String, RecipeItemStack> var4 = ShapedRecipes.keyFromJson(ChatDeserializer.getAsJsonObject(var1, "key"));
            String[] var5 = ShapedRecipes.shrink(ShapedRecipes.patternFromJson(ChatDeserializer.getAsJsonArray(var1, "pattern")));
            int var6 = var5[0].length();
            int var7 = var5.length;
            NonNullList<RecipeItemStack> var8 = ShapedRecipes.dissolvePattern(var5, var4, var6, var7);
            ItemStack var9 = ShapedRecipes.itemStackFromJson(ChatDeserializer.getAsJsonObject(var1, "result"));
            boolean var10 = ChatDeserializer.getAsBoolean(var1, "show_notification", true);
            return new ShapedRecipes(var0, var2, var3, var6, var7, var8, var9, var10);
        }

        @Override
        public ShapedRecipes fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            int var2 = var1.readVarInt();
            int var3 = var1.readVarInt();
            String var4 = var1.readUtf();
            CraftingBookCategory var5 = var1.readEnum(CraftingBookCategory.class);
            NonNullList<RecipeItemStack> var6 = NonNullList.withSize(var2 * var3, RecipeItemStack.EMPTY);
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                var6.set(var7, RecipeItemStack.fromNetwork(var1));
            }
            ItemStack var7 = var1.readItem();
            boolean var8 = var1.readBoolean();
            return new ShapedRecipes(var0, var4, var5, var2, var3, var6, var7, var8);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, ShapedRecipes var1) {
            var0.writeVarInt(var1.width);
            var0.writeVarInt(var1.height);
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            for (RecipeItemStack var3 : var1.recipeItems) {
                var3.toNetwork(var0);
            }
            var0.writeItem(var1.result);
            var0.writeBoolean(var1.showNotification);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }
    }
}

