/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;

public class RecipeSerializerCooking<T extends RecipeCooking>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final a<T> factory;

    public RecipeSerializerCooking(a<T> var0, int var1) {
        this.defaultCookingTime = var1;
        this.factory = var0;
    }

    @Override
    public T fromJson(MinecraftKey var0, JsonObject var1) {
        String var2 = ChatDeserializer.getAsString(var1, "group", "");
        CookingBookCategory var3 = CookingBookCategory.CODEC.byName(ChatDeserializer.getAsString(var1, "category", null), CookingBookCategory.MISC);
        JsonArray var4 = ChatDeserializer.isArrayNode(var1, "ingredient") ? ChatDeserializer.getAsJsonArray(var1, "ingredient") : ChatDeserializer.getAsJsonObject(var1, "ingredient");
        RecipeItemStack var5 = RecipeItemStack.fromJson((JsonElement)var4, false);
        String var6 = ChatDeserializer.getAsString(var1, "result");
        MinecraftKey var7 = new MinecraftKey(var6);
        ItemStack var8 = new ItemStack((IMaterial)BuiltInRegistries.ITEM.getOptional(var7).orElseThrow(() -> new IllegalStateException("Item: " + var6 + " does not exist")));
        float var9 = ChatDeserializer.getAsFloat(var1, "experience", 0.0f);
        int var10 = ChatDeserializer.getAsInt(var1, "cookingtime", this.defaultCookingTime);
        return this.factory.create(var0, var2, var3, var5, var8, var9, var10);
    }

    @Override
    public T fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
        String var2 = var1.readUtf();
        CookingBookCategory var3 = var1.readEnum(CookingBookCategory.class);
        RecipeItemStack var4 = RecipeItemStack.fromNetwork(var1);
        ItemStack var5 = var1.readItem();
        float var6 = var1.readFloat();
        int var7 = var1.readVarInt();
        return this.factory.create(var0, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public void toNetwork(PacketDataSerializer var0, T var1) {
        var0.writeUtf(((RecipeCooking)var1).group);
        var0.writeEnum(((RecipeCooking)var1).category());
        ((RecipeCooking)var1).ingredient.toNetwork(var0);
        var0.writeItem(((RecipeCooking)var1).result);
        var0.writeFloat(((RecipeCooking)var1).experience);
        var0.writeVarInt(((RecipeCooking)var1).cookingTime);
    }

    @Override
    public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
        return this.fromNetwork(minecraftKey, packetDataSerializer);
    }

    @Override
    public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
        return this.fromJson(minecraftKey, jsonObject);
    }

    static interface a<T extends RecipeCooking> {
        public T create(MinecraftKey var1, String var2, CookingBookCategory var3, RecipeItemStack var4, ItemStack var5, float var6, int var7);
    }
}

