/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworks
extends IRecipeComplex {
    private static final RecipeItemStack PAPER_INGREDIENT = RecipeItemStack.of(Items.PAPER);
    private static final RecipeItemStack GUNPOWDER_INGREDIENT = RecipeItemStack.of(Items.GUNPOWDER);
    private static final RecipeItemStack STAR_INGREDIENT = RecipeItemStack.of(Items.FIREWORK_STAR);

    public RecipeFireworks(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        int var3 = 0;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(var5)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(var5) ? ++var3 > 3 : !STAR_INGREDIENT.test(var5))) continue;
            return false;
        }
        return var2 && var3 >= 1;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        ItemStack var2 = new ItemStack(Items.FIREWORK_ROCKET, 3);
        NBTTagCompound var3 = var2.getOrCreateTagElement("Fireworks");
        NBTTagList var4 = new NBTTagList();
        int var5 = 0;
        for (int var6 = 0; var6 < var0.getContainerSize(); ++var6) {
            NBTTagCompound var8;
            ItemStack var7 = var0.getItem(var6);
            if (var7.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(var7)) {
                ++var5;
                continue;
            }
            if (!STAR_INGREDIENT.test(var7) || (var8 = var7.getTagElement("Explosion")) == null) continue;
            var4.add(var8);
        }
        var3.putByte("Flight", (byte)var5);
        if (!var4.isEmpty()) {
            var3.put("Explosions", var4);
        }
        return var2;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

