/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;

public class MobBucketItem
extends ItemBucket {
    private final EntityTypes<?> type;
    private final SoundEffect emptySound;

    public MobBucketItem(EntityTypes<?> var0, FluidType var1, SoundEffect var2, Item.Info var3) {
        super(var1, var3);
        this.type = var0;
        this.emptySound = var2;
    }

    @Override
    public void checkExtraContent(@Nullable EntityHuman var0, World var1, ItemStack var2, BlockPosition var3) {
        if (var1 instanceof WorldServer) {
            this.spawn((WorldServer)var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.ENTITY_PLACE, var3);
        }
    }

    @Override
    protected void playEmptySound(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2) {
        var1.playSound(var0, var2, this.emptySound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(WorldServer var0, ItemStack var1, BlockPosition var2) {
        Object var3 = this.type.spawn(var0, var1, null, var2, EnumMobSpawn.BUCKET, true, false);
        if (var3 instanceof Bucketable) {
            Bucketable var4 = (Bucketable)var3;
            var4.loadFromBucketTag(var1.getOrCreateTag());
            var4.setFromBucket(true);
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        NBTTagCompound var4;
        if (this.type == EntityTypes.TROPICAL_FISH && (var4 = var0.getTag()) != null && var4.contains("BucketVariantTag", 3)) {
            int var5 = var4.getInt("BucketVariantTag");
            EnumChatFormat[] var6 = new EnumChatFormat[]{EnumChatFormat.ITALIC, EnumChatFormat.GRAY};
            String var7 = "color.minecraft." + EntityTropicalFish.getBaseColor(var5);
            String var8 = "color.minecraft." + EntityTropicalFish.getPatternColor(var5);
            for (int var9 = 0; var9 < EntityTropicalFish.COMMON_VARIANTS.size(); ++var9) {
                if (var5 != EntityTropicalFish.COMMON_VARIANTS.get(var9).getPackedId()) continue;
                var2.add(IChatBaseComponent.translatable(EntityTropicalFish.getPredefinedName(var9)).withStyle(var6));
                return;
            }
            var2.add(EntityTropicalFish.getPattern(var5).displayName().plainCopy().withStyle(var6));
            IChatMutableComponent var9 = IChatBaseComponent.translatable(var7);
            if (!var7.equals(var8)) {
                var9.append(", ").append(IChatBaseComponent.translatable(var8));
            }
            var9.withStyle(var6);
            var2.add(var9);
        }
    }
}

