/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemShears
extends Item {
    public ItemShears(Item.Info var0) {
        super(var0);
    }

    @Override
    public boolean mineBlock(ItemStack var02, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        if (!var1.isClientSide && !var2.is(TagsBlock.FIRE)) {
            var02.hurtAndBreak(1, var4, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        }
        if (var2.is(TagsBlock.LEAVES) || var2.is(Blocks.COBWEB) || var2.is(Blocks.GRASS) || var2.is(Blocks.FERN) || var2.is(Blocks.DEAD_BUSH) || var2.is(Blocks.HANGING_ROOTS) || var2.is(Blocks.VINE) || var2.is(Blocks.TRIPWIRE) || var2.is(TagsBlock.WOOL)) {
            return true;
        }
        return super.mineBlock(var02, var1, var2, var3, var4);
    }

    @Override
    public boolean isCorrectToolForDrops(IBlockData var0) {
        return var0.is(Blocks.COBWEB) || var0.is(Blocks.REDSTONE_WIRE) || var0.is(Blocks.TRIPWIRE);
    }

    @Override
    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        if (var1.is(Blocks.COBWEB) || var1.is(TagsBlock.LEAVES)) {
            return 15.0f;
        }
        if (var1.is(TagsBlock.WOOL)) {
            return 5.0f;
        }
        if (var1.is(Blocks.VINE) || var1.is(Blocks.GLOW_LICHEN)) {
            return 2.0f;
        }
        return super.getDestroySpeed(var0, var1);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockGrowingTop var5;
        BlockPosition var2;
        World var12 = var0.getLevel();
        IBlockData var3 = var12.getBlockState(var2 = var0.getClickedPos());
        Block var4 = var3.getBlock();
        if (var4 instanceof BlockGrowingTop && !(var5 = (BlockGrowingTop)var4).isMaxAge(var3)) {
            EntityHuman var6 = var0.getPlayer();
            ItemStack var7 = var0.getItemInHand();
            if (var6 instanceof EntityPlayer) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var6, var2, var7);
            }
            var12.playSound(var6, var2, SoundEffects.GROWING_PLANT_CROP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            IBlockData var8 = var5.getMaxAgeState(var3);
            var12.setBlockAndUpdate(var2, var8);
            var12.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0.getPlayer(), var8));
            if (var6 != null) {
                var7.hurtAndBreak(1, var6, var1 -> var1.broadcastBreakEvent(var0.getHand()));
            }
            return EnumInteractionResult.sidedSuccess(var12.isClientSide);
        }
        return super.useOn(var0);
    }
}

