/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFireworks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;

public class ItemFireworksCharge
extends Item {
    public ItemFireworksCharge(Item.Info var0) {
        super(var0);
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        NBTTagCompound var4 = var0.getTagElement("Explosion");
        if (var4 != null) {
            ItemFireworksCharge.appendHoverText(var4, var2);
        }
    }

    public static void appendHoverText(NBTTagCompound var0, List<IChatBaseComponent> var1) {
        int[] var4;
        ItemFireworks.EffectType var2 = ItemFireworks.EffectType.byId(var0.getByte("Type"));
        var1.add(IChatBaseComponent.translatable("item.minecraft.firework_star.shape." + var2.getName()).withStyle(EnumChatFormat.GRAY));
        int[] var3 = var0.getIntArray("Colors");
        if (var3.length > 0) {
            var1.add(ItemFireworksCharge.appendColors(IChatBaseComponent.empty().withStyle(EnumChatFormat.GRAY), var3));
        }
        if ((var4 = var0.getIntArray("FadeColors")).length > 0) {
            var1.add(ItemFireworksCharge.appendColors(IChatBaseComponent.translatable("item.minecraft.firework_star.fade_to").append(CommonComponents.SPACE).withStyle(EnumChatFormat.GRAY), var4));
        }
        if (var0.getBoolean("Trail")) {
            var1.add(IChatBaseComponent.translatable("item.minecraft.firework_star.trail").withStyle(EnumChatFormat.GRAY));
        }
        if (var0.getBoolean("Flicker")) {
            var1.add(IChatBaseComponent.translatable("item.minecraft.firework_star.flicker").withStyle(EnumChatFormat.GRAY));
        }
    }

    private static IChatBaseComponent appendColors(IChatMutableComponent var0, int[] var1) {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 > 0) {
                var0.append(", ");
            }
            var0.append(ItemFireworksCharge.getColorName(var1[var2]));
        }
        return var0;
    }

    private static IChatBaseComponent getColorName(int var0) {
        EnumColor var1 = EnumColor.byFireworkColor(var0);
        if (var1 == null) {
            return IChatBaseComponent.translatable("item.minecraft.firework_star.custom_color");
        }
        return IChatBaseComponent.translatable("item.minecraft.firework_star." + var1.getName());
    }
}

