/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemFireball
extends Item {
    public ItemFireball(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var3 = var1.getBlockState(var2);
        boolean var4 = false;
        if (BlockCampfire.canLight(var3) || CandleBlock.canLight(var3) || CandleCakeBlock.canLight(var3)) {
            this.playSound(var1, var2);
            var1.setBlockAndUpdate(var2, (IBlockData)var3.setValue(BlockProperties.LIT, true));
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_CHANGE, var2);
            var4 = true;
        } else if (BlockFireAbstract.canBePlacedAt(var1, var2 = var2.relative(var0.getClickedFace()), var0.getHorizontalDirection())) {
            this.playSound(var1, var2);
            var1.setBlockAndUpdate(var2, BlockFireAbstract.getState(var1, var2));
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_PLACE, var2);
            var4 = true;
        }
        if (var4) {
            var0.getItemInHand().shrink(1);
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.FAIL;
    }

    private void playSound(World var0, BlockPosition var1) {
        RandomSource var2 = var0.getRandom();
        var0.playSound(null, var1, SoundEffects.FIRECHARGE_USE, SoundCategory.BLOCKS, 1.0f, (var2.nextFloat() - var2.nextFloat()) * 0.2f + 1.0f);
    }
}

