/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class ItemArmorStand
extends Item {
    public ItemArmorStand(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EnumDirection var1 = var0.getClickedFace();
        if (var1 == EnumDirection.DOWN) {
            return EnumInteractionResult.FAIL;
        }
        World var2 = var0.getLevel();
        BlockActionContext var3 = new BlockActionContext(var0);
        BlockPosition var4 = var3.getClickedPos();
        ItemStack var5 = var0.getItemInHand();
        Vec3D var6 = Vec3D.atBottomCenterOf(var4);
        AxisAlignedBB var7 = EntityTypes.ARMOR_STAND.getDimensions().makeBoundingBox(var6.x(), var6.y(), var6.z());
        if (!var2.noCollision(null, var7) || !var2.getEntities(null, var7).isEmpty()) {
            return EnumInteractionResult.FAIL;
        }
        if (var2 instanceof WorldServer) {
            WorldServer var8 = (WorldServer)var2;
            Consumer var9 = EntityTypes.createDefaultStackConfig(var8, var5, var0.getPlayer());
            EntityArmorStand var10 = EntityTypes.ARMOR_STAND.create(var8, var5.getTag(), var9, var4, EnumMobSpawn.SPAWN_EGG, true, true);
            if (var10 == null) {
                return EnumInteractionResult.FAIL;
            }
            float var11 = (float)MathHelper.floor((MathHelper.wrapDegrees(var0.getRotation() - 180.0f) + 22.5f) / 45.0f) * 45.0f;
            var10.moveTo(var10.getX(), var10.getY(), var10.getZ(), var11, 0.0f);
            var8.addFreshEntityWithPassengers(var10);
            var2.playSound(null, var10.getX(), var10.getY(), var10.getZ(), SoundEffects.ARMOR_STAND_PLACE, SoundCategory.BLOCKS, 0.75f, 0.8f);
            var10.gameEvent(GameEvent.ENTITY_PLACE, var0.getPlayer());
        }
        var5.shrink(1);
        return EnumInteractionResult.sidedSuccess(var2.isClientSide);
    }
}

