/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;

public class BundleItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = MathHelper.color(0.4f, 0.4f, 1.0f);

    public BundleItem(Item.Info var0) {
        super(var0);
    }

    public static float getFullnessDisplay(ItemStack var0) {
        return (float)BundleItem.getContentWeight(var0) / 64.0f;
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var22, EntityHuman var3) {
        if (var22 != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack var4 = var1.getItem();
        if (var4.isEmpty()) {
            this.playRemoveOneSound(var3);
            BundleItem.removeOne(var0).ifPresent(var2 -> BundleItem.add(var0, var1.safeInsert((ItemStack)var2)));
        } else if (var4.getItem().canFitInsideContainerItems()) {
            int var5 = (64 - BundleItem.getContentWeight(var0)) / BundleItem.getWeight(var4);
            int var6 = BundleItem.add(var0, var1.safeTake(var4.getCount(), var5, var3));
            if (var6 > 0) {
                this.playInsertSound(var3);
            }
        }
        return true;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var22, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        if (var3 != ClickAction.SECONDARY || !var22.allowModification(var4)) {
            return false;
        }
        if (var1.isEmpty()) {
            BundleItem.removeOne(var0).ifPresent(var2 -> {
                this.playRemoveOneSound(var4);
                var5.set((ItemStack)var2);
            });
        } else {
            int var6 = BundleItem.add(var0, var1);
            if (var6 > 0) {
                this.playInsertSound(var4);
                var1.shrink(var6);
            }
        }
        return true;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (BundleItem.dropContents(var3, var1)) {
            this.playDropContentsSound(var1);
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public boolean isBarVisible(ItemStack var0) {
        return BundleItem.getContentWeight(var0) > 0;
    }

    @Override
    public int getBarWidth(ItemStack var0) {
        return Math.min(1 + 12 * BundleItem.getContentWeight(var0) / 64, 13);
    }

    @Override
    public int getBarColor(ItemStack var0) {
        return BAR_COLOR;
    }

    private static int add(ItemStack var0, ItemStack var1) {
        if (var1.isEmpty() || !var1.getItem().canFitInsideContainerItems()) {
            return 0;
        }
        NBTTagCompound var2 = var0.getOrCreateTag();
        if (!var2.contains(TAG_ITEMS)) {
            var2.put(TAG_ITEMS, new NBTTagList());
        }
        int var3 = BundleItem.getContentWeight(var0);
        int var4 = BundleItem.getWeight(var1);
        int var5 = Math.min(var1.getCount(), (64 - var3) / var4);
        if (var5 == 0) {
            return 0;
        }
        NBTTagList var6 = var2.getList(TAG_ITEMS, 10);
        Optional<NBTTagCompound> var7 = BundleItem.getMatchingItem(var1, var6);
        if (var7.isPresent()) {
            NBTTagCompound var8 = var7.get();
            ItemStack var9 = ItemStack.of(var8);
            var9.grow(var5);
            var9.save(var8);
            var6.remove(var8);
            var6.add(0, var8);
        } else {
            ItemStack var8 = var1.copyWithCount(var5);
            NBTTagCompound var9 = new NBTTagCompound();
            var8.save(var9);
            var6.add(0, var9);
        }
        return var5;
    }

    private static Optional<NBTTagCompound> getMatchingItem(ItemStack var0, NBTTagList var12) {
        if (var0.is(Items.BUNDLE)) {
            return Optional.empty();
        }
        return var12.stream().filter(NBTTagCompound.class::isInstance).map(NBTTagCompound.class::cast).filter(var1 -> ItemStack.isSameItemSameTags(ItemStack.of(var1), var0)).findFirst();
    }

    private static int getWeight(ItemStack var0) {
        NBTTagCompound var1;
        if (var0.is(Items.BUNDLE)) {
            return 4 + BundleItem.getContentWeight(var0);
        }
        if ((var0.is(Items.BEEHIVE) || var0.is(Items.BEE_NEST)) && var0.hasTag() && (var1 = ItemBlock.getBlockEntityData(var0)) != null && !var1.getList("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / var0.getMaxStackSize();
    }

    private static int getContentWeight(ItemStack var02) {
        return BundleItem.getContents(var02).mapToInt(var0 -> BundleItem.getWeight(var0) * var0.getCount()).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack var0) {
        NBTTagCompound var1 = var0.getOrCreateTag();
        if (!var1.contains(TAG_ITEMS)) {
            return Optional.empty();
        }
        NBTTagList var2 = var1.getList(TAG_ITEMS, 10);
        if (var2.isEmpty()) {
            return Optional.empty();
        }
        boolean var3 = false;
        NBTTagCompound var4 = var2.getCompound(0);
        ItemStack var5 = ItemStack.of(var4);
        var2.remove(0);
        if (var2.isEmpty()) {
            var0.removeTagKey(TAG_ITEMS);
        }
        return Optional.of(var5);
    }

    private static boolean dropContents(ItemStack var0, EntityHuman var1) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        if (!var2.contains(TAG_ITEMS)) {
            return false;
        }
        if (var1 instanceof EntityPlayer) {
            NBTTagList var3 = var2.getList(TAG_ITEMS, 10);
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                NBTTagCompound var5 = var3.getCompound(var4);
                ItemStack var6 = ItemStack.of(var5);
                var1.drop(var6, true);
            }
        }
        var0.removeTagKey(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 == null) {
            return Stream.empty();
        }
        NBTTagList var2 = var1.getList(TAG_ITEMS, 10);
        return var2.stream().map(NBTTagCompound.class::cast).map(ItemStack::of);
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        NonNullList<ItemStack> var1 = NonNullList.create();
        BundleItem.getContents(var0).forEach(var1::add);
        return Optional.of(new BundleTooltip(var1, BundleItem.getContentWeight(var0)));
    }

    @Override
    public void appendHoverText(ItemStack var0, World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        var2.add(IChatBaseComponent.translatable("item.minecraft.bundle.fullness", BundleItem.getContentWeight(var0), 64).withStyle(EnumChatFormat.GRAY));
    }

    @Override
    public void onDestroyed(EntityItem var0) {
        ItemLiquidUtil.onContainerDestroyed(var0, BundleItem.getContents(var0.getItem()));
    }

    private void playRemoveOneSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_INSERT, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }
}

