/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class ContainerLoom
extends Container {
    private static final int PATTERN_NOT_SET = -1;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final ContainerAccess access;
    final ContainerProperty selectedBannerPatternIndex = ContainerProperty.standalone();
    private List<Holder<EnumBannerPatternType>> selectablePatterns = List.of();
    Runnable slotUpdateListener = () -> {};
    final Slot bannerSlot;
    final Slot dyeSlot;
    private final Slot patternSlot;
    private final Slot resultSlot;
    long lastSoundTime;
    private final IInventory inputContainer = new InventorySubcontainer(3){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerLoom.this.slotsChanged(this);
            ContainerLoom.this.slotUpdateListener.run();
        }
    };
    private final IInventory outputContainer = new InventorySubcontainer(1){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerLoom.this.slotUpdateListener.run();
        }
    };

    public ContainerLoom(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerLoom(int var0, PlayerInventory var1, final ContainerAccess var2) {
        super(Containers.LOOM, var0);
        int var3;
        this.access = var2;
        this.bannerSlot = this.addSlot(new Slot(this.inputContainer, 0, 13, 26){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemBanner;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this.inputContainer, 1, 33, 26){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemDye;
            }
        });
        this.patternSlot = this.addSlot(new Slot(this.inputContainer, 2, 23, 45){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemBannerPattern;
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 143, 58){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public void onTake(EntityHuman var02, ItemStack var12) {
                ContainerLoom.this.bannerSlot.remove(1);
                ContainerLoom.this.dyeSlot.remove(1);
                if (!ContainerLoom.this.bannerSlot.hasItem() || !ContainerLoom.this.dyeSlot.hasItem()) {
                    ContainerLoom.this.selectedBannerPatternIndex.set(-1);
                }
                var2.execute((var0, var1) -> {
                    long var22 = var0.getGameTime();
                    if (ContainerLoom.this.lastSoundTime != var22) {
                        var0.playSound(null, (BlockPosition)var1, SoundEffects.UI_LOOM_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerLoom.this.lastSoundTime = var22;
                    }
                });
                super.onTake(var02, var12);
            }
        });
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
        this.addDataSlot(this.selectedBannerPatternIndex);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerLoom.stillValid(this.access, var0, Blocks.LOOM);
    }

    @Override
    public boolean clickMenuButton(EntityHuman var0, int var1) {
        if (var1 >= 0 && var1 < this.selectablePatterns.size()) {
            this.selectedBannerPatternIndex.set(var1);
            this.setupResultSlot(this.selectablePatterns.get(var1));
            return true;
        }
        return false;
    }

    private List<Holder<EnumBannerPatternType>> getSelectablePatterns(ItemStack var0) {
        if (var0.isEmpty()) {
            return (List)BuiltInRegistries.BANNER_PATTERN.getTag(BannerPatternTags.NO_ITEM_REQUIRED).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = var0.getItem();
        if (item instanceof ItemBannerPattern) {
            ItemBannerPattern var1 = (ItemBannerPattern)item;
            return (List)BuiltInRegistries.BANNER_PATTERN.getTag(var1.getBannerPattern()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }

    private boolean isValidPatternIndex(int var0) {
        return var0 >= 0 && var0 < this.selectablePatterns.size();
    }

    @Override
    public void slotsChanged(IInventory var0) {
        int var9;
        Object var8;
        Object var7;
        ItemStack var1 = this.bannerSlot.getItem();
        ItemStack var2 = this.dyeSlot.getItem();
        ItemStack var3 = this.patternSlot.getItem();
        if (var1.isEmpty() || var2.isEmpty()) {
            this.resultSlot.set(ItemStack.EMPTY);
            this.selectablePatterns = List.of();
            this.selectedBannerPatternIndex.set(-1);
            return;
        }
        int var4 = this.selectedBannerPatternIndex.get();
        boolean var5 = this.isValidPatternIndex(var4);
        List<Holder<EnumBannerPatternType>> var6 = this.selectablePatterns;
        this.selectablePatterns = this.getSelectablePatterns(var3);
        if (this.selectablePatterns.size() == 1) {
            this.selectedBannerPatternIndex.set(0);
            var7 = this.selectablePatterns.get(0);
        } else if (!var5) {
            this.selectedBannerPatternIndex.set(-1);
            var7 = null;
        } else {
            var8 = var6.get(var4);
            var9 = this.selectablePatterns.indexOf(var8);
            if (var9 != -1) {
                var7 = var8;
                this.selectedBannerPatternIndex.set(var9);
            } else {
                var7 = null;
                this.selectedBannerPatternIndex.set(-1);
            }
        }
        if (var7 != null) {
            var8 = ItemBlock.getBlockEntityData(var1);
            int n2 = var9 = var8 != null && ((NBTTagCompound)var8).contains("Patterns", 9) && !var1.isEmpty() && ((NBTTagCompound)var8).getList("Patterns", 10).size() >= 6 ? 1 : 0;
            if (var9 != 0) {
                this.selectedBannerPatternIndex.set(-1);
                this.resultSlot.set(ItemStack.EMPTY);
            } else {
                this.setupResultSlot((Holder<EnumBannerPatternType>)var7);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public List<Holder<EnumBannerPatternType>> getSelectablePatterns() {
        return this.selectablePatterns;
    }

    public int getSelectedBannerPatternIndex() {
        return this.selectedBannerPatternIndex.get();
    }

    public void registerUpdateListener(Runnable var0) {
        this.slotUpdateListener = var0;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == this.resultSlot.index) {
                if (!this.moveItemStackTo(var4, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == this.dyeSlot.index || var1 == this.bannerSlot.index || var1 == this.patternSlot.index ? !this.moveItemStackTo(var4, 4, 40, false) : (var4.getItem() instanceof ItemBanner ? !this.moveItemStackTo(var4, this.bannerSlot.index, this.bannerSlot.index + 1, false) : (var4.getItem() instanceof ItemDye ? !this.moveItemStackTo(var4, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (var4.getItem() instanceof ItemBannerPattern ? !this.moveItemStackTo(var4, this.patternSlot.index, this.patternSlot.index + 1, false) : (var1 >= 4 && var1 < 31 ? !this.moveItemStackTo(var4, 31, 40, false) : var1 >= 31 && var1 < 40 && !this.moveItemStackTo(var4, 4, 31, false)))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.inputContainer));
    }

    private void setupResultSlot(Holder<EnumBannerPatternType> var0) {
        ItemStack var1 = this.bannerSlot.getItem();
        ItemStack var2 = this.dyeSlot.getItem();
        ItemStack var3 = ItemStack.EMPTY;
        if (!var1.isEmpty() && !var2.isEmpty()) {
            NBTTagList var6;
            var3 = var1.copyWithCount(1);
            EnumColor var4 = ((ItemDye)var2.getItem()).getDyeColor();
            NBTTagCompound var5 = ItemBlock.getBlockEntityData(var3);
            if (var5 != null && var5.contains("Patterns", 9)) {
                var6 = var5.getList("Patterns", 10);
            } else {
                var6 = new NBTTagList();
                if (var5 == null) {
                    var5 = new NBTTagCompound();
                }
                var5.put("Patterns", var6);
            }
            NBTTagCompound var7 = new NBTTagCompound();
            var7.putString("Pattern", var0.value().getHashname());
            var7.putInt("Color", var4.getId());
            var6.add(var7);
            ItemBlock.setBlockEntityData(var3, TileEntityTypes.BANNER, var5);
        }
        if (!ItemStack.matches(var3, this.resultSlot.getItem())) {
            this.resultSlot.set(var3);
        }
    }

    public Slot getBannerSlot() {
        return this.bannerSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

