/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.mojang.serialization.Codec;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagRegistry;
import net.minecraft.world.flag.FeatureFlagSet;

public class FeatureFlags {
    public static final FeatureFlag VANILLA;
    public static final FeatureFlag BUNDLE;
    public static final FeatureFlagRegistry REGISTRY;
    public static final Codec<FeatureFlagSet> CODEC;
    public static final FeatureFlagSet VANILLA_SET;
    public static final FeatureFlagSet DEFAULT_FLAGS;

    public static String printMissingFlags(FeatureFlagSet var0, FeatureFlagSet var1) {
        return FeatureFlags.printMissingFlags(REGISTRY, var0, var1);
    }

    public static String printMissingFlags(FeatureFlagRegistry var0, FeatureFlagSet var12, FeatureFlagSet var2) {
        Set<MinecraftKey> var3 = var0.toNames(var2);
        Set<MinecraftKey> var4 = var0.toNames(var12);
        return var3.stream().filter(var1 -> !var4.contains(var1)).map(MinecraftKey::toString).collect(Collectors.joining(", "));
    }

    public static boolean isExperimental(FeatureFlagSet var0) {
        return !var0.isSubsetOf(VANILLA_SET);
    }

    static {
        FeatureFlagRegistry.a var0 = new FeatureFlagRegistry.a("main");
        VANILLA = var0.createVanilla("vanilla");
        BUNDLE = var0.createVanilla("bundle");
        REGISTRY = var0.build();
        CODEC = REGISTRY.codec();
        DEFAULT_FLAGS = VANILLA_SET = FeatureFlagSet.of(VANILLA);
    }
}

