/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataWatcherObject<Boolean> DATA_DANGEROUS = DataWatcher.defineId(EntityWitherSkull.class, DataWatcherRegistry.BOOLEAN);

    public EntityWitherSkull(EntityTypes<? extends EntityWitherSkull> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public EntityWitherSkull(World var0, EntityLiving var1, double var2, double var4, double var6) {
        super(EntityTypes.WITHER_SKULL, var1, var2, var4, var6, var0);
    }

    @Override
    protected float getInertia() {
        return this.isDangerous() ? 0.73f : super.getInertia();
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        if (this.isDangerous() && EntityWither.canDestroy(var3)) {
            return Math.min(0.8f, var5);
        }
        return var5;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        boolean var3;
        EntityLiving var4;
        super.onHitEntity(var0);
        if (this.level().isClientSide) {
            return;
        }
        Entity var1 = var0.getEntity();
        Entity var2 = this.getOwner();
        if (var2 instanceof EntityLiving) {
            var4 = (EntityLiving)var2;
            var3 = var1.hurt(this.damageSources().witherSkull(this, var4), 8.0f);
            if (var3) {
                if (var1.isAlive()) {
                    this.doEnchantDamageEffects(var4, var1);
                } else {
                    var4.heal(5.0f);
                }
            }
        } else {
            var3 = var1.hurt(this.damageSources().magic(), 5.0f);
        }
        if (var3 && var1 instanceof EntityLiving) {
            var4 = (EntityLiving)var1;
            int var5 = 0;
            if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                var5 = 10;
            } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                var5 = 40;
            }
            if (var5 > 0) {
                var4.addEffect(new MobEffect(MobEffects.WITHER, 20 * var5, 1), this.getEffectSource());
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, false, World.a.MOB);
            this.discard();
        }
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        return false;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_DANGEROUS, false);
    }

    public boolean isDangerous() {
        return this.entityData.get(DATA_DANGEROUS);
    }

    public void setDangerous(boolean var0) {
        this.entityData.set(DATA_DANGEROUS, var0);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

