/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityIllagerIllusioner
extends EntityIllagerWizard
implements IRangedEntity {
    private static final int NUM_ILLUSIONS = 4;
    private static final int ILLUSION_TRANSITION_TICKS = 3;
    private static final int ILLUSION_SPREAD = 3;
    private int clientSideIllusionTicks;
    private final Vec3D[][] clientSideIllusionOffsets;

    public EntityIllagerIllusioner(EntityTypes<? extends EntityIllagerIllusioner> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerWizard>)var0, var1);
        this.xpReward = 5;
        this.clientSideIllusionOffsets = new Vec3D[2][4];
        for (int var2 = 0; var2 < 4; ++var2) {
            this.clientSideIllusionOffsets[0][var2] = Vec3D.ZERO;
            this.clientSideIllusionOffsets[1][var2] = Vec3D.ZERO;
        }
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new EntityIllagerWizard.b());
        this.goalSelector.addGoal(4, new b());
        this.goalSelector.addGoal(5, new a());
        this.goalSelector.addGoal(6, new PathfinderGoalBowShoot<EntityIllagerIllusioner>(this, 0.5, 20, 15.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false).setUnseenMemoryTicks(300));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.5).add(GenericAttributes.FOLLOW_RANGE, 18.0).add(GenericAttributes.MAX_HEALTH, 32.0);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.BOW));
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(3.0, 0.0, 3.0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide && this.isInvisible()) {
            --this.clientSideIllusionTicks;
            if (this.clientSideIllusionTicks < 0) {
                this.clientSideIllusionTicks = 0;
            }
            if (this.hurtTime == 1 || this.tickCount % 1200 == 0) {
                int var2;
                this.clientSideIllusionTicks = 3;
                float var0 = -6.0f;
                int var1 = 13;
                for (var2 = 0; var2 < 4; ++var2) {
                    this.clientSideIllusionOffsets[0][var2] = this.clientSideIllusionOffsets[1][var2];
                    this.clientSideIllusionOffsets[1][var2] = new Vec3D((double)(-6.0f + (float)this.random.nextInt(13)) * 0.5, Math.max(0, this.random.nextInt(6) - 4), (double)(-6.0f + (float)this.random.nextInt(13)) * 0.5);
                }
                for (var2 = 0; var2 < 16; ++var2) {
                    this.level().addParticle(Particles.CLOUD, this.getRandomX(0.5), this.getRandomY(), this.getZ(0.5), 0.0, 0.0, 0.0);
                }
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ILLUSIONER_MIRROR_MOVE, this.getSoundSource(), 1.0f, 1.0f, false);
            } else if (this.hurtTime == this.hurtDuration - 1) {
                this.clientSideIllusionTicks = 3;
                for (int var0 = 0; var0 < 4; ++var0) {
                    this.clientSideIllusionOffsets[0][var0] = this.clientSideIllusionOffsets[1][var0];
                    this.clientSideIllusionOffsets[1][var0] = new Vec3D(0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.ILLUSIONER_AMBIENT;
    }

    public Vec3D[] getIllusionOffsets(float var0) {
        if (this.clientSideIllusionTicks <= 0) {
            return this.clientSideIllusionOffsets[1];
        }
        double var1 = ((float)this.clientSideIllusionTicks - var0) / 3.0f;
        var1 = Math.pow(var1, 0.25);
        Vec3D[] var3 = new Vec3D[4];
        for (int var4 = 0; var4 < 4; ++var4) {
            var3[var4] = this.clientSideIllusionOffsets[1][var4].scale(1.0 - var1).add(this.clientSideIllusionOffsets[0][var4].scale(var1));
        }
        return var3;
    }

    @Override
    public boolean isAlliedTo(Entity var0) {
        if (super.isAlliedTo(var0)) {
            return true;
        }
        if (var0 instanceof EntityLiving && ((EntityLiving)var0).getMobType() == EnumMonsterType.ILLAGER) {
            return this.getTeam() == null && var0.getTeam() == null;
        }
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ILLUSIONER_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ILLUSIONER_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ILLUSIONER_HURT;
    }

    @Override
    protected SoundEffect getCastingSoundEvent() {
        return SoundEffects.ILLUSIONER_CAST_SPELL;
    }

    @Override
    public void applyRaidBuffs(int var0, boolean var1) {
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        ItemStack var2 = this.getProjectile(this.getItemInHand(ProjectileHelper.getWeaponHoldingHand(this, Items.BOW)));
        EntityArrow var3 = ProjectileHelper.getMobArrow(this, var2, var1);
        double var4 = var0.getX() - this.getX();
        double var6 = var0.getY(0.3333333333333333) - var3.getY();
        double var8 = var0.getZ() - this.getZ();
        double var10 = Math.sqrt(var4 * var4 + var8 * var8);
        var3.shoot(var4, var6 + var10 * (double)0.2f, var8, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
        this.playSound(SoundEffects.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity(var3);
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        if (this.isCastingSpell()) {
            return EntityIllagerAbstract.a.SPELLCASTING;
        }
        if (this.isAggressive()) {
            return EntityIllagerAbstract.a.BOW_AND_ARROW;
        }
        return EntityIllagerAbstract.a.CROSSED;
    }

    class b
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        b() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return !EntityIllagerIllusioner.this.hasEffect(MobEffects.INVISIBILITY);
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            EntityIllagerIllusioner.this.addEffect(new MobEffect(MobEffects.INVISIBILITY, 1200));
        }

        @Override
        @Nullable
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.ILLUSIONER_PREPARE_MIRROR;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.DISAPPEAR;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private int lastTargetId;

        a() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            if (EntityIllagerIllusioner.this.getTarget() == null) {
                return false;
            }
            if (EntityIllagerIllusioner.this.getTarget().getId() == this.lastTargetId) {
                return false;
            }
            return EntityIllagerIllusioner.this.level().getCurrentDifficultyAt(EntityIllagerIllusioner.this.blockPosition()).isHarderThan(EnumDifficulty.NORMAL.ordinal());
        }

        @Override
        public void start() {
            super.start();
            EntityLiving var0 = EntityIllagerIllusioner.this.getTarget();
            if (var0 != null) {
                this.lastTargetId = var0.getId();
            }
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 180;
        }

        @Override
        protected void performSpellCasting() {
            EntityIllagerIllusioner.this.getTarget().addEffect(new MobEffect(MobEffects.BLINDNESS, 400), EntityIllagerIllusioner.this);
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.ILLUSIONER_PREPARE_BLINDNESS;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.BLINDNESS;
        }
    }
}

